/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedType;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Type;

public class TypeRepository
implements ITypeRepository {
    private final Map<String, IType[]> types;
    private final Map<String, Boolean> packages;
    private final ManagedTypeProvider mtp;
    private final Elements elements;

    TypeRepository(Project project, ManagedTypeProvider mtp, Elements elements) {
        this.mtp = mtp;
        this.elements = elements;
        this.types = new HashMap<String, IType[]>();
        this.packages = new HashMap<String, Boolean>();
    }

    public IType getEnumType(String fqn) {
        IType[] ret = this.types.get(fqn);
        if (ret == null) {
            String mainPart;
            int lastPoint = fqn.lastIndexOf(46);
            String string = mainPart = lastPoint > 0 ? fqn.substring(0, lastPoint) : null;
            if (mainPart != null) {
                IType[] mainType = this.types.get(mainPart);
                if (mainType == null) {
                    int mainLastPoint;
                    int mainFirstPoint = mainPart.indexOf(46);
                    if (mainFirstPoint != (mainLastPoint = mainPart.lastIndexOf(46)) && mainFirstPoint > -1) {
                        int packagePartIndex = mainFirstPoint;
                        while (packagePartIndex < mainLastPoint && packagePartIndex > -1) {
                            String packageStr = mainPart.substring(0, packagePartIndex);
                            Boolean exist = this.packages.get(packageStr);
                            if (exist == null) {
                                this.packages.put(packageStr, this.elements.getPackageElement(packageStr) != null);
                                exist = this.packages.get(packageStr);
                            }
                            if (Boolean.FALSE.equals(exist)) {
                                mainType = new Type[]{null};
                                this.types.put(mainPart, mainType);
                                break;
                            }
                            packagePartIndex = mainPart.indexOf(46, packagePartIndex + 1);
                        }
                    } else if (mainFirstPoint == -1) {
                        mainType = new Type[]{null};
                        this.types.put(mainPart, mainType);
                    }
                    if (mainType == null) {
                        this.fillTypeElement(mainPart);
                    }
                }
                if ((mainType = this.types.get(mainPart))[0] != null) {
                    this.fillTypeElement(fqn);
                } else {
                    this.types.put(fqn, new Type[]{null});
                }
            } else {
                this.fillTypeElement(fqn);
            }
            ret = this.types.get(fqn);
        }
        return ret[0];
    }

    public IType getType(Class<?> type) {
        String fqn = type.getCanonicalName();
        IType[] ret = this.types.get(fqn);
        if (ret == null) {
            this.fillTypeElement(type);
            ret = this.types.get(fqn);
        }
        return ret[0];
    }

    public IType getType(String fqn) {
        IType[] ret = this.types.get(fqn);
        if (ret == null && this.isValid()) {
            if ("UNRESOLVABLE_TYPE".equals(fqn)) {
                this.types.put(fqn, new Type[]{new Type((ITypeRepository)this, fqn)});
            } else {
                int lastPnt = fqn.lastIndexOf(46);
                ManagedType mt = (ManagedType)(lastPnt > -1 ? this.mtp.getManagedType(fqn.substring(lastPnt + 1)) : this.mtp.getManagedType(fqn));
                if (mt != null && mt.getPersistentObject() != null && mt.getPersistentObject().getTypeElement() != null && mt.getPersistentObject().getTypeElement().getQualifiedName().contentEquals(fqn)) {
                    this.types.put(fqn, new Type[]{new Type((ITypeRepository)this, mt.getPersistentObject())});
                } else {
                    this.fillTypeElement(fqn);
                }
            }
            ret = this.types.get(fqn);
        }
        if (ret == null || ret[0] == null) {
            ret = new Type[]{new Type((ITypeRepository)this, (String)null)};
            this.types.put(fqn, ret);
        }
        return ret[0];
    }

    public TypeHelper getTypeHelper() {
        return new TypeHelper((ITypeRepository)this);
    }

    private void fillTypeElement(String fqn) {
        TypeElement te;
        this.types.put(fqn, new Type[]{null});
        if (this.isValid() && this.isValid() && (te = this.elements.getTypeElement(fqn)) != null) {
            this.types.put(fqn, new Type[]{new Type((ITypeRepository)this, te)});
        }
    }

    private void fillTypeElement(Class<?> type) {
        this.types.put(type.getName(), new Type[]{new Type((ITypeRepository)this, type)});
    }

    boolean isValid() {
        return this.mtp.isValid();
    }

    void invalidate() {
    }
}

