/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public final class ProjectSelectionPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ProjectSelectionPanel.class.getName());
    private ProjectWizardPanel wizard;
    private EclipseProject[] projects;
    private Set<EclipseProject> selectedProjects;
    private Set<EclipseProject> requiredProjects;
    private ButtonGroup buttonGroup1;
    private JButton chooseDestButton;
    private JTextField destination;
    private JRadioButton jRadioInsideEclipse;
    private JRadioButton jRadioSeparate;
    private JLabel prjLocationLBL;
    private JLabel prjLocationLBL1;
    private JLabel projectListLabel;
    private JTable projectTable;
    private JScrollPane projectTableSP;

    public void updateValidity() {
        if (this.selectedProjects == null || this.selectedProjects.isEmpty()) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ProjectIsNotChosed"));
            return;
        }
        boolean exists = false;
        if (this.jRadioInsideEclipse.isSelected()) {
            for (EclipseProject prj : this.allProjects()) {
                if (!new File(prj.getDirectory(), "nbproject").exists()) continue;
                exists = true;
                break;
            }
        } else {
            if (this.destination.getText().length() == 0) {
                this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_DestinationIsEmpty"));
                return;
            }
            File f = new File(this.destination.getText());
            if (f.exists()) {
                for (EclipseProject prj : this.allProjects()) {
                    if (!new File(f, prj.getDirectory().getName()).exists()) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"MSG_AlreadyImportedProjects"), true);
        } else {
            this.wizard.setErrorMessage(null);
        }
    }

    public boolean isSeparateFolder() {
        return this.jRadioSeparate.isSelected();
    }

    private Collection<EclipseProject> allProjects() {
        HashSet<EclipseProject> all = new HashSet<EclipseProject>(this.selectedProjects);
        all.addAll(this.requiredProjects);
        return all;
    }

    private void solveDependencies() {
        this.requiredProjects.clear();
        this.requiredProjects.addAll(ProjectSelectionPanel.getFlattenedRequiredProjects(this.selectedProjects));
    }

    public static Set<EclipseProject> getFlattenedRequiredProjects(Set<EclipseProject> selectedProjects) {
        Stack<EclipseProject> solved = new Stack<EclipseProject>();
        HashSet<EclipseProject> requiredProjects = new HashSet<EclipseProject>();
        if (selectedProjects == null || selectedProjects.isEmpty()) {
            return requiredProjects;
        }
        for (EclipseProject selProject : selectedProjects) {
            assert (selProject != null);
            solved.push(selProject);
            EclipseProject currentRoot = selProject;
            ProjectSelectionPanel.fillUpRequiredProjects(selProject, solved, requiredProjects);
            EclipseProject poped = solved.pop();
            assert (poped.equals(currentRoot));
            assert (solved.isEmpty());
            currentRoot = null;
        }
        return requiredProjects;
    }

    private static void fillUpRequiredProjects(EclipseProject project, Stack<EclipseProject> solved, Set<EclipseProject> requiredProjects) {
        for (EclipseProject child : project.getProjects()) {
            assert (child != null);
            if (solved.contains(child)) {
                ProjectSelectionPanel.recursionDetected(child, solved);
                return;
            }
            requiredProjects.add(child);
            solved.push(child);
            ProjectSelectionPanel.fillUpRequiredProjects(child, solved, requiredProjects);
            EclipseProject popped = solved.pop();
            assert (popped.equals(child));
        }
    }

    private static void recursionDetected(EclipseProject start, Stack<EclipseProject> solved) {
        int where = solved.search(start);
        assert (where != -1) : "Cannot find start of the cycle.";
        EclipseProject rootOfCycle = (EclipseProject)solved.get(solved.size() - where);
        StringBuffer cycle = new StringBuffer();
        for (EclipseProject p : solved) {
            cycle.append(p.getName()).append(" --> ");
        }
        cycle.append(rootOfCycle.getName()).append(" --> ...");
        logger.warning("Cycle dependencies was detected. Detected cycle: " + cycle);
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)ProjectImporterWizard.getMessage("MSG_CycleDependencies", cycle.toString()), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    ProjectSelectionPanel(ProjectWizardPanel wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.init();
        this.destination.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectSelectionPanel.this.updateValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectSelectionPanel.this.updateValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.updateValidity();
        this.jRadioInsideEclipse.setSelected(true);
        this.enableLocation(false);
        TableColumn column = this.projectTable.getColumnModel().getColumn(0);
        column.setMaxWidth(25);
        column.setMinWidth(25);
    }

    private void init() {
        this.projectTable.setModel(new ProjectTableModel());
        this.projectTable.setTableHeader(null);
        this.projectTable.getSelectionModel().setSelectionMode(0);
        this.projectTable.getColumnModel().getColumn(0).setCellRenderer(new ProjectCheckboxEditorAndRenderer());
        this.projectTable.getColumnModel().getColumn(1).setCellRenderer(new ProjectNameRenderer());
        this.projectTable.setDefaultEditor(Boolean.class, new ProjectCheckboxEditorAndRenderer());
        this.projectTableSP.getViewport().setBackground(this.projectTable.getBackground());
        this.destination.setText(ProjectChooser.getProjectsFolder().getPath());
    }

    void loadProjects(File workspaceDir) {
        WorkspaceFactory.getInstance().resetCache();
        Workspace workspace = null;
        try {
            workspace = WorkspaceFactory.getInstance().load(workspaceDir);
        }
        catch (ProjectImporterException e) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_WorkspaceIsInvalid", workspaceDir));
            logger.log(Level.FINE, "ProjectImporterException catched", e);
            return;
        }
        TreeSet<EclipseProject> wsPrjs = new TreeSet<EclipseProject>(workspace.getProjects());
        this.projects = wsPrjs.toArray(new EclipseProject[wsPrjs.size()]);
        this.selectedProjects = new HashSet<EclipseProject>();
        this.requiredProjects = new HashSet<EclipseProject>();
        if (this.projects.length == 0) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_WorkspaceIsEmpty", workspaceDir));
        } else {
            this.updateValidity();
        }
    }

    List<EclipseProject> getProjects() {
        return ProjectSelectionPanel.getFlattenedProjects(this.selectedProjects);
    }

    public static List<EclipseProject> getFlattenedProjects(Set<EclipseProject> selectedProjects) {
        ArrayList<EclipseProject> list = new ArrayList<EclipseProject>();
        ProjectSelectionPanel.addProjects(selectedProjects, list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            EclipseProject eclipseProject = (EclipseProject)it.next();
            if (eclipseProject.isImportSupported()) continue;
            it.remove();
        }
        return list;
    }

    private static void addProjects(Set<EclipseProject> projects, List<EclipseProject> list) {
        for (EclipseProject p : projects) {
            if (list.contains(p)) continue;
            Set<EclipseProject> requiredProjs = p.getProjects();
            if (requiredProjs.size() == 0) {
                list.add(p);
                continue;
            }
            ProjectSelectionPanel.addProjects(requiredProjs, list);
            list.add(p);
        }
    }

    int getNumberOfImportedProject() {
        return this.allProjects().size();
    }

    String getDestination() {
        if (this.isSeparateFolder()) {
            return this.destination.getText();
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.projectListLabel = new JLabel();
        this.projectTableSP = new JScrollPane();
        this.projectTable = new JTable();
        this.prjLocationLBL = new JLabel();
        this.destination = new JTextField();
        this.chooseDestButton = new JButton();
        this.jRadioInsideEclipse = new JRadioButton();
        this.jRadioSeparate = new JRadioButton();
        this.prjLocationLBL1 = new JLabel();
        this.projectListLabel.setLabelFor(this.projectTable);
        Mnemonics.setLocalizedText((JLabel)this.projectListLabel, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_ProjectsToImport"));
        this.projectListLabel.setVerticalTextPosition(1);
        this.projectTable.setOpaque(false);
        this.projectTable.setShowHorizontalLines(false);
        this.projectTable.setShowVerticalLines(false);
        this.projectTableSP.setViewportView(this.projectTable);
        this.projectTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL.setLabelFor(this.jRadioInsideEclipse);
        Mnemonics.setLocalizedText((JLabel)this.prjLocationLBL, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_LocationOfNBProjects"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDestButton, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"CTL_BrowseButton_B"));
        this.chooseDestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSelectionPanel.this.chooseDestButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioInsideEclipse);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioInsideEclipse, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"RADIO_LOCATION_ECLIPSE"));
        this.jRadioInsideEclipse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSelectionPanel.this.jRadioInsideEclipseActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioSeparate);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioSeparate, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"RADIO_LOCATION_SEPARATE"));
        this.jRadioSeparate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSelectionPanel.this.jRadioSeparateActionPerformed(evt);
            }
        });
        this.prjLocationLBL1.setLabelFor(this.destination);
        Mnemonics.setLocalizedText((JLabel)this.prjLocationLBL1, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_LocationOfNBProjects2"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.prjLocationLBL).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.prjLocationLBL1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.destination, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseDestButton)).addComponent(this.projectTableSP, -1, 524, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioInsideEclipse, -1, 516, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioSeparate, -1, 516, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.projectListLabel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.projectListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectTableSP, -1, 214, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prjLocationLBL).addGap(0, 0, 0).addComponent(this.jRadioInsideEclipse).addGap(0, 0, 0).addComponent(this.jRadioSeparate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.prjLocationLBL1).addComponent(this.chooseDestButton).addComponent(this.destination, -2, -1, -2))));
        this.projectListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.projectTableSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.projectTableSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.destination.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.chooseDestButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.jRadioInsideEclipse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.jRadioSeparate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
    }

    private void chooseDestButtonActionPerformed(ActionEvent evt) {
        File dest = new FileChooserBuilder(ProjectSelectionPanel.class).setDirectoriesOnly(true).showOpenDialog();
        if (dest != null) {
            this.destination.setText(dest.getAbsolutePath());
        }
    }

    private void jRadioInsideEclipseActionPerformed(ActionEvent evt) {
        this.enableLocation(false);
    }

    private void jRadioSeparateActionPerformed(ActionEvent evt) {
        this.enableLocation(true);
    }

    private void enableLocation(boolean enable) {
        this.prjLocationLBL1.setEnabled(enable);
        this.destination.setEnabled(enable);
        this.chooseDestButton.setEnabled(enable);
    }

    private class ProjectTableModel
    extends AbstractTableModel {
        private ProjectTableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            EclipseProject project = ProjectSelectionPanel.this.projects[rowIndex];
            if (columnIndex == 0) {
                return ProjectSelectionPanel.this.selectedProjects.contains(project) || ProjectSelectionPanel.this.requiredProjects.contains(project);
            }
            if (project.isImportSupported()) {
                return project.getName() + " (" + project.getProjectTypeFactory().getProjectTypeName() + ")";
            }
            return project.getName() + " (unknown project type)";
        }

        @Override
        public int getRowCount() {
            return ProjectSelectionPanel.this.projects != null ? ProjectSelectionPanel.this.projects.length : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && ProjectSelectionPanel.this.projects[rowIndex].isImportSupported() && !ProjectSelectionPanel.this.requiredProjects.contains(ProjectSelectionPanel.this.projects[rowIndex]);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            EclipseProject project = ProjectSelectionPanel.this.projects[rowIndex];
            assert (ProjectSelectionPanel.this.projects != null);
            if (((Boolean)aValue).booleanValue()) {
                ProjectSelectionPanel.this.selectedProjects.add(project);
            } else {
                ProjectSelectionPanel.this.selectedProjects.remove(project);
            }
            ProjectSelectionPanel.this.solveDependencies();
            this.fireColumnDataChanged();
            ProjectSelectionPanel.this.updateValidity();
            ProjectSelectionPanel.this.wizard.fireProjectListChanged();
        }

        private void fireColumnDataChanged() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.fireTableCellUpdated(i, 0);
            }
        }
    }

    private class ProjectNameRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private ProjectNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                label.setOpaque(isSelected);
                EclipseProject project = ProjectSelectionPanel.this.projects[row];
                if (project.isImportSupported()) {
                    label.setIcon(project.getProjectTypeFactory().getProjectTypeIcon());
                } else {
                    label.setIcon(null);
                }
            }
            return c;
        }
    }

    private class ProjectCheckboxEditorAndRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private JCheckBox checkbox;

        private ProjectCheckboxEditorAndRenderer() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        private JCheckBox createComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            EclipseProject project = ProjectSelectionPanel.this.projects[row];
            JCheckBox chb = new JCheckBox();
            chb.setSelected(ProjectSelectionPanel.this.selectedProjects.contains(project) || ProjectSelectionPanel.this.requiredProjects.contains(project));
            chb.setToolTipText(null);
            if (project.isImportSupported() && !ProjectSelectionPanel.this.requiredProjects.contains(project)) {
                chb.setEnabled(true);
            } else {
                chb.setEnabled(false);
                if (!project.isImportSupported()) {
                    chb.setToolTipText(ProjectImporterWizard.getMessage("MSG_NonJavaProject", project.getName()));
                }
            }
            if (isSelected) {
                chb.setOpaque(true);
                chb.setForeground(table.getSelectionForeground());
                chb.setBackground(table.getSelectionBackground());
            } else {
                chb.setOpaque(false);
                chb.setForeground(table.getForeground());
                chb.setBackground(table.getBackground());
            }
            return chb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.checkbox = this.createComponent(table, value, isSelected, isSelected, row, column);
            this.checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ProjectCheckboxEditorAndRenderer.this.fireEditingStopped();
                }
            });
            return this.checkbox;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.checkbox = this.createComponent(table, value, isSelected, isSelected, row, column);
            return this.checkbox;
        }
    }
}

