/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.env;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

public class ShellClasspathProvider
implements ClassPathProvider {
    public ClassPath findClassPath(FileObject file, String type) {
        JShellEnvironment jshe = ShellRegistry.get().getOwnerEnvironment(file);
        if (jshe == null) {
            return null;
        }
        ShellSession ss = jshe.getSession();
        if (ss == null) {
            return null;
        }
        ClasspathInfo cpi = ss.getClasspathInfo();
        if (cpi == null) {
            return null;
        }
        switch (type) {
            case "modules/boot": {
                return cpi.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT);
            }
            case "modules/compile": {
                return cpi.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE);
            }
            case "modules/classpath": {
                return cpi.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS);
            }
            case "modules/source": {
                return cpi.getClassPath(ClasspathInfo.PathKind.MODULE_SOURCE);
            }
            case "classpath/compile": {
                return cpi.getClassPath(ClasspathInfo.PathKind.COMPILE);
            }
            case "classpath/source": {
                return cpi.getClassPath(ClasspathInfo.PathKind.SOURCE);
            }
            case "classpath/boot": {
                return cpi.getClassPath(ClasspathInfo.PathKind.BOOT);
            }
        }
        return null;
    }
}

