/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tomcat.loader.ClassRepository;
import org.apache.tomcat.loader.SimpleFileFilter;

public class AdaptiveClassLoader
extends ClassLoader {
    private static final int debug = 0;
    protected static SecurityManager sm;
    private static int generationCounter;
    private int generation;
    protected Hashtable cache = new Hashtable();
    protected Vector repository;
    protected ClassLoader parent;

    public void setRepository(Vector classRepository) throws IllegalArgumentException {
        Enumeration e = classRepository.elements();
        while (e.hasMoreElements()) {
            File file;
            ClassRepository cp = (ClassRepository)e.nextElement();
            try {
                file = cp.getFile();
            }
            catch (ClassCastException objectIsNotFile) {
                throw new IllegalArgumentException("Object " + cp + "is not a valid \"File\" instance");
            }
            String[] files = SimpleFileFilter.fileOrFiles(file);
            if (files == null) continue;
            int i = 0;
            while (i < files.length) {
                file = new File(files[i]);
                if (!file.exists()) {
                    throw new IllegalArgumentException("Repository " + file.getAbsolutePath() + " doesn't exist!");
                }
                if (!file.canRead()) {
                    throw new IllegalArgumentException("Do not have read access for file " + file.getAbsolutePath());
                }
                if (!file.isDirectory() && !this.isZipOrJarArchive(file)) {
                    throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or zip/jar file" + " or if it's a zip/jar file then it is corrupted.");
                }
                ++i;
            }
        }
        this.repository = classRepository;
        this.generation = generationCounter++;
    }

    public void setParent(ClassLoader p) {
        this.parent = p;
    }

    void log(String s) {
        System.out.println("AdaptiveClassLoader: " + s);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var7_4 = null;
        if (zipFile == null) return isArchive;
        try {
            zipFile.close();
            return isArchive;
        }
        catch (IOException ignored) {}
        return isArchive;
        {
            catch (ZipException zipCurrupted) {
                isArchive = false;
                Object var7_5 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
            catch (IOException anyIOError) {
                isArchive = false;
                Object var7_6 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean shouldReload(String classname) {
        return this.checkExpired(classname);
    }

    protected boolean checkExpired(String classname) {
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(classname);
        if (entry == null) {
            return false;
        }
        if (entry.isSystemClass()) {
            return false;
        }
        return entry.origin.lastModified() != entry.lastModified;
    }

    public synchronized boolean shouldReload() {
        Enumeration e = this.cache.elements();
        while (e.hasMoreElements()) {
            ClassCacheEntry entry = (ClassCacheEntry)e.nextElement();
            if (entry.loadedClass == null || entry.isSystemClass()) continue;
            long msOrigin = entry.origin.lastModified();
            if (msOrigin == 0L) {
                return true;
            }
            if (msOrigin == entry.lastModified) continue;
            return true;
        }
        return false;
    }

    public AdaptiveClassLoader reinstantiate() {
        AdaptiveClassLoader cl = new AdaptiveClassLoader();
        cl.setParent(this.parent);
        cl.setRepository(this.repository);
        return cl;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        Class c = null;
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(name);
        if (entry != null) {
            c = entry.loadedClass;
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (sm != null && (i = name.lastIndexOf(46)) >= 0) {
            sm.checkPackageAccess(name.substring(0, i));
            sm.checkPackageDefinition(name.substring(0, i));
        }
        if (this.parent != null) {
            try {
                c = this.parent.loadClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException e) {
                c = null;
            }
            catch (Exception e) {
                c = null;
            }
        }
        try {
            c = this.loadSystemClass(name, resolve);
            if (c != null) {
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        Enumeration repEnum = this.repository.elements();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (repEnum.hasMoreElements()) {
            byte[] classData = null;
            ClassRepository cp = (ClassRepository)repEnum.nextElement();
            File file = cp.getFile();
            try {
                classData = file.isDirectory() ? this.loadClassFromDirectory(file, name, classCache) : this.loadClassFromZipfile(file, name, classCache);
            }
            catch (SecurityException sex) {
                sex.printStackTrace();
                throw sex;
            }
            catch (IOException ioe) {
                classData = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (classData == null) continue;
            classCache.lastModified = classCache.origin.lastModified();
            this.cache.put(name, classCache);
            try {
                classCache.loadedClass = this.doDefineClass(name, classData, cp.getProtectionDomain());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (resolve) {
                this.resolveClass(classCache.loadedClass);
            }
            return classCache.loadedClass;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class doDefineClass(String name, byte[] classData, Object pd) {
        return this.defineClass(name, classData, 0, classData.length);
    }

    private Class loadSystemClass(String name, boolean resolve) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> c = this.findSystemClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] loadClassFromDirectory(File dir, String name, ClassCacheEntry cache) throws IOException {
        File classFile;
        String classFileName = name.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(classFileName.charAt(0))) {
            int start = 1;
            while (!Character.isJavaIdentifierStart(classFileName.charAt(start++))) {
            }
            classFileName = classFileName.substring(start);
        }
        if ((classFile = new File(dir, classFileName)).exists()) {
            byte[] byArray;
            cache.origin = classFile;
            FileInputStream in = new FileInputStream(classFile);
            try {
                byArray = this.loadBytesFromStream(in, (int)classFile.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassFromZipfile(File file, String name, ClassCacheEntry cache) throws IOException {
        byte[] byArray;
        ZipFile zipfile;
        block4: {
            byte[] byArray2;
            block3: {
                String classFileName = name.replace('.', '/') + ".class";
                zipfile = new ZipFile(file);
                try {
                    ZipEntry entry = zipfile.getEntry(classFileName);
                    if (entry != null) {
                        cache.origin = file;
                        byArray2 = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize());
                        Object var9_9 = null;
                        break block3;
                    }
                    byArray = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    zipfile.close();
                    throw throwable;
                }
            }
            zipfile.close();
            return byArray2;
        }
        Object var9_10 = null;
        zipfile.close();
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            void var4_5;
            count += var4_5;
            length -= var4_5;
        }
        return buf;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream s = null;
        if (this.parent != null && (s = this.parent.getResourceAsStream(name)) != null) {
            return s;
        }
        s = ClassLoader.getSystemResourceAsStream(name);
        if (s == null) {
            Enumeration repEnum = this.repository.elements();
            while (repEnum.hasMoreElements()) {
                ClassRepository cp = (ClassRepository)repEnum.nextElement();
                File file = cp.getFile();
                if (file.isDirectory()) {
                    s = this.loadResourceFromDirectory(file, name);
                } else if (name.endsWith(".initArgs")) {
                    File dir = new File(file.getParent());
                    s = this.loadResourceFromDirectory(dir, name);
                } else {
                    s = this.loadResourceFromZipfile(file, name);
                }
                if (s != null) break;
            }
        }
        return s;
    }

    private InputStream loadResourceFromDirectory(File dir, String name) {
        String fileName = name.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return new FileInputStream(resFile);
            }
            catch (FileNotFoundException shouldnothappen) {
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream loadResourceFromZipfile(File file, String name) {
        block10: {
            zipfile = null;
            try {
                try {
                    zipfile = new ZipFile(file);
                    entry = zipfile.getEntry(name);
                    if (entry == null || (data = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize())) == null) break block10;
                    var7_8 = istream = new ByteArrayInputStream(data);
                    var9_9 = null;
                    if (zipfile == null) return var7_8;
                }
                catch (IOException e) {
                    var9_11 = null;
                    if (zipfile == null) return null;
                    try {
                        zipfile.close();
                        return null;
                    }
                    catch (IOException ignored) {
                        return null;
                    }
                }
            }
            catch (Throwable var8_17) {
                var9_12 = null;
                if (zipfile == null) throw var8_17;
                ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl26:
                // 1 sources

                zipfile.close();
                throw var8_17;
lbl28:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                throw var8_17;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl33:
            // 1 sources

            zipfile.close();
            return var7_8;
lbl35:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var7_8;
        }
        var9_10 = null;
        if (zipfile == null) return null;
        try {}
        catch (IOException ignored) {}
        zipfile.close();
        return null;
        return null;
    }

    public URL getResource(String name) {
        URL u = null;
        if (this.parent != null && (u = this.parent.getResource(name)) != null) {
            return u;
        }
        u = ClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        if (name == null) {
            return null;
        }
        u = this.findResourceInternal(name);
        if (u != null) {
            return u;
        }
        return null;
    }

    protected URL findResourceInternal(String name) {
        try {
            return (URL)this.findResourcesInternal(name, true).elementAt(0);
        }
        catch (IOException e) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    protected Vector findResourcesInternal(String name, boolean justOne) throws IOException {
        Vector<URL> urls = new Vector<URL>(this.repository.size());
        Enumeration repEnum = this.repository.elements();
        while (repEnum.hasMoreElements()) {
            ClassRepository cp = (ClassRepository)repEnum.nextElement();
            File file = cp.getFile();
            if (file.isDirectory()) {
                String fileName = name.replace('/', File.separatorChar);
                File resFile = new File(file, fileName);
                if (!resFile.exists()) continue;
                try {
                    urls.add(new URL("file", null, resFile.getAbsolutePath()));
                    if (!justOne) continue;
                    return urls;
                }
                catch (MalformedURLException badurl) {
                    badurl.printStackTrace();
                    return null;
                }
            }
            try {
                ZipFile zf = new ZipFile(file.getAbsolutePath());
                ZipEntry ze = zf.getEntry(name);
                zf.close();
                if (ze == null) continue;
                try {
                    urls.add(new URL("jar:file:" + file.getAbsolutePath() + "!/" + name));
                    if (!justOne) continue;
                    return urls;
                }
                catch (MalformedURLException badurl) {
                    badurl.printStackTrace();
                    return null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        return urls;
    }

    public String toString() {
        return "AdaptiveClassLoader(  )";
    }

    static {
        generationCounter = 0;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

