/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.codegen;

import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LoremIpsumPanel
extends JPanel {
    private List<String> paragraphs;
    private int[] wordCount;
    private int[] characterCount;
    private JLabel characterCountLabel;
    private JTextField characterCountTextField;
    private JLabel paragraphCountLabel;
    private JSpinner paragraphCountSpinner;
    private JComboBox separatedByComboBox;
    private JLabel separatedByLabel;
    private JLabel wordCountLabel;
    private JTextField wordCountTextField;

    public LoremIpsumPanel(List<String> paragraphs) {
        this.paragraphs = paragraphs;
        this.initCounts();
        this.initComponents();
        this.updateDisplayedCounts();
    }

    public List<String> getParagraphs() {
        return this.paragraphs.subList(0, (Integer)this.paragraphCountSpinner.getValue());
    }

    public String getTag() {
        return (String)this.separatedByComboBox.getSelectedItem();
    }

    private void initCounts() {
        this.characterCount = new int[this.paragraphs.size() + 1];
        this.wordCount = new int[this.paragraphs.size() + 1];
        this.characterCount[0] = 0;
        this.wordCount[0] = 0;
        for (int i = 1; i <= this.paragraphs.size(); ++i) {
            String paragraph = this.paragraphs.get(i - 1);
            this.characterCount[i] = this.characterCount[i - 1] + paragraph.length();
            this.wordCount[i] = this.wordCount[i - 1] + LoremIpsumPanel.countWords(paragraph);
        }
    }

    private static int countWords(String text) {
        int words = 1;
        for (char c : text.toCharArray()) {
            if (c != ' ') continue;
            ++words;
        }
        return words;
    }

    private void initComponents() {
        this.paragraphCountLabel = new JLabel();
        this.paragraphCountSpinner = new JSpinner();
        this.wordCountLabel = new JLabel();
        this.characterCountLabel = new JLabel();
        this.wordCountTextField = new JTextField();
        this.characterCountTextField = new JTextField();
        this.separatedByLabel = new JLabel();
        this.separatedByComboBox = new JComboBox();
        this.setMinimumSize(new Dimension(380, 220));
        this.setName("Form");
        this.setPreferredSize(new Dimension(400, 220));
        this.paragraphCountLabel.setLabelFor(this.paragraphCountSpinner);
        Mnemonics.setLocalizedText((JLabel)this.paragraphCountLabel, (String)NbBundle.getMessage(LoremIpsumPanel.class, (String)"LoremIpsumPanel.paragraphCountLabel.text"));
        this.paragraphCountLabel.setName("paragraphCountLabel");
        this.paragraphCountSpinner.setModel(new SpinnerNumberModel(4, 1, 10, 1));
        this.paragraphCountSpinner.setName("paragraphCountSpinner");
        this.paragraphCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LoremIpsumPanel.this.paragraphCountSpinnerStateChanged(evt);
            }
        });
        this.wordCountLabel.setText(NbBundle.getMessage(LoremIpsumPanel.class, (String)"LoremIpsumPanel.wordCountLabel.text"));
        this.wordCountLabel.setName("wordCountLabel");
        this.characterCountLabel.setText(NbBundle.getMessage(LoremIpsumPanel.class, (String)"LoremIpsumPanel.characterCountLabel.text"));
        this.characterCountLabel.setName("characterCountLabel");
        this.wordCountTextField.setColumns(5);
        this.wordCountTextField.setEditable(false);
        this.wordCountTextField.setName("wordCountTextField");
        this.characterCountTextField.setColumns(5);
        this.characterCountTextField.setEditable(false);
        this.characterCountTextField.setName("characterCountTextField");
        this.separatedByLabel.setLabelFor(this.separatedByComboBox);
        Mnemonics.setLocalizedText((JLabel)this.separatedByLabel, (String)NbBundle.getMessage(LoremIpsumPanel.class, (String)"LoremIpsumPanel.separatedByLabel.text"));
        this.separatedByLabel.setName("separatedByLabel");
        this.separatedByComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<p>", "<div>", "<span>"}));
        this.separatedByComboBox.setName("separatedByComboBox");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separatedByLabel).addComponent(this.wordCountLabel).addComponent(this.characterCountLabel).addComponent(this.paragraphCountLabel)).addGap(76, 76, 76).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wordCountTextField, -1, 119, Short.MAX_VALUE).addComponent(this.separatedByComboBox, 0, 119, Short.MAX_VALUE).addComponent(this.characterCountTextField, -1, 119, Short.MAX_VALUE).addComponent(this.paragraphCountSpinner, -1, 119, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.paragraphCountLabel).addComponent(this.paragraphCountSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.separatedByLabel).addComponent(this.separatedByComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wordCountLabel).addComponent(this.wordCountTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.characterCountLabel).addComponent(this.characterCountTextField, -2, -1, -2)).addContainerGap(63, Short.MAX_VALUE)));
    }

    private void paragraphCountSpinnerStateChanged(ChangeEvent evt) {
        this.updateDisplayedCounts();
    }

    private void updateDisplayedCounts() {
        Integer value = (Integer)this.paragraphCountSpinner.getValue();
        this.wordCountTextField.setText(Integer.toString(this.wordCount[value]));
        this.characterCountTextField.setText(Integer.toString(this.characterCount[value]));
    }
}

