/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class BinaryForSourceImpl
implements BinaryForSourceQueryImplementation {
    private final NbModuleProject project;
    private final ConcurrentMap<URI, BinaryForSourceQuery.Result> cache;

    public BinaryForSourceImpl(@NonNull NbModuleProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
        this.cache = new ConcurrentHashMap<URI, BinaryForSourceQuery.Result>();
    }

    public BinaryForSourceQuery.Result findBinaryRoots(@NonNull URL sourceRoot) {
        try {
            URI key = sourceRoot.toURI();
            BinaryForSourceQuery.Result res = (BinaryForSourceQuery.Result)this.cache.get(key);
            if (res == null) {
                BinaryForSourceQuery.Result oldRes;
                Object genSrcDir;
                URL binRoot = null;
                FileObject srcDir = this.project.getSourceDirectory();
                if (srcDir != null && srcDir.toURI().equals(key)) {
                    binRoot = Utilities.toURI((File)this.project.getClassesDirectory()).toURL();
                }
                if (binRoot == null && (genSrcDir = this.project.getGeneratedClassesDirectory()) != null && Utilities.toURI((File)genSrcDir).equals(key)) {
                    binRoot = Utilities.toURI((File)this.project.getClassesDirectory()).toURL();
                }
                if (binRoot == null) {
                    for (String testKind : this.project.supportedTestTypes()) {
                        FileObject testSrcDir = this.project.getTestSourceDirectory(testKind);
                        if (testSrcDir != null && testSrcDir.toURI().equals(key)) {
                            binRoot = Utilities.toURI((File)this.project.getTestClassesDirectory(testKind)).toURL();
                            break;
                        }
                        File testGenSrcDir = this.project.getTestGeneratedClassesDirectory(testKind);
                        if (testGenSrcDir == null || !Utilities.toURI((File)testGenSrcDir).equals(key)) continue;
                        binRoot = Utilities.toURI((File)this.project.getTestClassesDirectory(testKind)).toURL();
                        break;
                    }
                }
                if (binRoot != null && (oldRes = this.cache.putIfAbsent(key, res = new ResImpl(binRoot))) != null) {
                    res = oldRes;
                }
            }
            return res;
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
        }
        catch (URISyntaxException use) {
            Exceptions.printStackTrace((Throwable)use);
        }
        return null;
    }

    private class ResImpl
    implements BinaryForSourceQuery.Result {
        private final URL binDir;

        private ResImpl(URL binDir) {
            this.binDir = binDir;
        }

        @NonNull
        public URL[] getRoots() {
            return new URL[]{this.binDir};
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

