/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.support.FixFactory;
import org.openide.util.NbBundle;

public class ClassStructure {
    public static ErrorDescription finalClass(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        if (cls.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)cls, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalClass", (Object)cls.getSimpleName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)cls.getModifiers()), EnumSet.of(Modifier.FINAL), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromClass", (Object)cls.getSimpleName()))});
        }
        return null;
    }

    public static ErrorDescription finalMethod(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        if (mth.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalMethod", (Object)mth.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)mth.getName()))});
        }
        return null;
    }

    public static ErrorDescription finalPrivateMethod(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        if (mth.getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.PRIVATE))) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalPrivateMethod", (Object)mth.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)mth.getName()))});
        }
        return null;
    }

    public static ErrorDescription finalMethodInFinalClass(HintContext context) {
        ExecutableElement ee;
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && mth.getModifiers().getFlags().contains((Object)Modifier.FINAL) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL) && ((ee = (ExecutableElement)context.getInfo().getTrees().getElement(context.getPath())) == null || ee.getAnnotation(SafeVarargs.class) == null)) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalMethodInFinalClass", (Object)mth.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)mth.getName()))});
        }
        return null;
    }

    public static ErrorDescription noopMethodInAbstractClass(HintContext context) {
        BlockTree body;
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && (body = mth.getBody()) != null && body.getStatements().isEmpty()) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_NoopMethodInAbstractClass", (Object)mth.getName()), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription publicConstructorInNonPublicClass(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && mth.getReturnType() == null && "<init>".contentEquals(mth.getName()) && mth.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) && !((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_PublicConstructorInNonPublicClass", (Object)mth.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.PUBLIC), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemovePublicFromConstructor"))});
        }
        return null;
    }

    public static ErrorDescription protectedMemberInFinalClass(HintContext context) {
        Tree tree = context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind())) {
            if (tree.getKind() == Tree.Kind.METHOD) {
                MethodTree mth = (MethodTree)tree;
                if (mth.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    Element el = context.getInfo().getTrees().getElement(context.getPath());
                    if (el == null || el.getKind() != ElementKind.METHOD) {
                        return null;
                    }
                    LinkedList overrides = new LinkedList();
                    ComputeOverriding.detectOverrides((CompilationInfo)context.getInfo(), (TypeElement)((TypeElement)el.getEnclosingElement()), (ExecutableElement)((ExecutableElement)el), overrides);
                    for (ElementDescription ed : overrides) {
                        Element res = ed.getHandle().resolve(context.getInfo());
                        if (res == null || !res.getModifiers().contains((Object)Modifier.PROTECTED) && !res.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                        return null;
                    }
                    return ErrorDescriptionFactory.forName((HintContext)context, (Tree)mth, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_ProtectedMethodInFinalClass", (Object)mth.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.PROTECTED), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveProtectedFromMethod", (Object)mth.getName()))});
                }
            } else {
                VariableTree var = (VariableTree)tree;
                if (var.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    return ErrorDescriptionFactory.forName((HintContext)context, (Tree)var, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_ProtectedFieldInFinalClass", (Object)var.getName()), (Fix[])new Fix[]{FixFactory.removeModifiersFix((CompilationInfo)context.getInfo(), (TreePath)TreePath.getPath(context.getPath(), (Tree)var.getModifiers()), EnumSet.of(Modifier.PROTECTED), (String)NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveProtectedFromField", (Object)var.getName()))});
                }
            }
        }
        return null;
    }

    public static ErrorDescription markerInterface(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        if (context.getInfo().getTreeUtilities().isInterface(cls) && cls.getMembers().isEmpty() && cls.getImplementsClause().size() < 2) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)cls, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_MarkerInterface", (Object)cls.getSimpleName()), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription classMayBeInterface(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        TreeUtilities treeUtilities = context.getInfo().getTreeUtilities();
        if (treeUtilities.isClass(cls) && ClassStructure.testClassMayBeInterface(context.getInfo().getTrees(), treeUtilities, context.getPath())) {
            return ErrorDescriptionFactory.forName((HintContext)context, (Tree)cls, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_ClassMayBeInterface", (Object)cls.getSimpleName()), (Fix[])new Fix[]{new ConvertClassToInterfaceFixImpl(TreePathHandle.create((TreePath)context.getPath(), (CompilationInfo)context.getInfo()), NbBundle.getMessage(ClassStructure.class, (String)"FIX_ConvertClassToInterface", (Object)cls.getSimpleName())).toEditorFix()});
        }
        return null;
    }

    public static ErrorDescription multipleTopLevelClassesInFile(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.COMPILATION_UNIT) {
            ArrayList<? extends Tree> typeDecls = new ArrayList<Tree>(((CompilationUnitTree)parent).getTypeDecls());
            Iterator it = typeDecls.iterator();
            while (it.hasNext()) {
                if (((Tree)it.next()).getKind() != Tree.Kind.EMPTY_STATEMENT) continue;
                it.remove();
            }
            if (typeDecls.size() > 1 && typeDecls.get(0) != cls) {
                return ErrorDescriptionFactory.forName((HintContext)context, (Tree)cls, (String)NbBundle.getMessage(ClassStructure.class, (String)"MSG_MultipleTopLevelClassesInFile"), (Fix[])new Fix[0]);
            }
        }
        return null;
    }

    private static boolean testClassMayBeInterface(Trees trees, TreeUtilities treeUtilities, TreePath path) {
        TypeMirror superclass;
        ClassTree cls = (ClassTree)path.getLeaf();
        if (!treeUtilities.isClass(cls)) {
            return true;
        }
        Element element = trees.getElement(path);
        if (element == null) {
            return false;
        }
        TypeMirror typeMirror = superclass = element.getKind().isClass() ? ((TypeElement)element).getSuperclass() : null;
        if (superclass == null || superclass.getKind() != TypeKind.DECLARED || !"java.lang.Object".contentEquals(((TypeElement)((DeclaredType)superclass).asElement()).getQualifiedName())) {
            return false;
        }
        block5: for (Tree tree : cls.getMembers()) {
            TreePath memberPath = TreePath.getPath(path, tree);
            if (treeUtilities.isSynthetic(memberPath)) continue;
            switch (tree.getKind()) {
                case VARIABLE: {
                    if (((VariableTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL))) continue block5;
                    return false;
                }
                case METHOD: {
                    if (((MethodTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT))) continue block5;
                    return false;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (ClassStructure.testClassMayBeInterface(trees, treeUtilities, memberPath)) continue block5;
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private static final class ConvertClassToInterfaceFixImpl
    extends JavaFix {
        private final String text;

        public ConvertClassToInterfaceFixImpl(TreePathHandle clsHandle, String text) {
            super(clsHandle);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            TreePath path = ctx.getPath();
            ClassTree cls = (ClassTree)path.getLeaf();
            gu.importComments((Tree)cls, wc.getCompilationUnit());
            TreeMaker treeMaker = wc.getTreeMaker();
            ModifiersTree mods = cls.getModifiers();
            if (mods.getFlags().contains((Object)Modifier.ABSTRACT)) {
                EnumSet<Modifier> modifiers = EnumSet.copyOf(mods.getFlags());
                modifiers.remove((Object)Modifier.ABSTRACT);
                ModifiersTree nmods = treeMaker.Modifiers(modifiers, mods.getAnnotations());
                gu.copyComments((Tree)mods, (Tree)nmods, true);
                gu.copyComments((Tree)mods, (Tree)nmods, false);
                mods = nmods;
            }
            ClassTree nue = treeMaker.Interface(mods, (CharSequence)cls.getSimpleName(), cls.getTypeParameters(), cls.getImplementsClause(), cls.getMembers());
            gu.copyComments((Tree)cls, (Tree)nue, true);
            gu.copyComments((Tree)cls, (Tree)nue, false);
            wc.rewrite(path.getLeaf(), (Tree)nue);
        }
    }
}

