/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage.api;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.Exceptions;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoverageProviderHelper {
    private static final String COVERAGE_NAMESPACE_URI = "http://www.netbeans.org/ns/code-coverage/1";

    private CoverageProviderHelper() {
    }

    public static boolean isEnabled(Project project) {
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element configurationFragment = config.getConfigurationFragment("coverage", COVERAGE_NAMESPACE_URI, false);
        if (configurationFragment == null) {
            return false;
        }
        return configurationFragment.getAttribute("enabled").equals("true");
    }

    public static void setEnabled(Project project, boolean enabled) {
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        if (ProjectManager.getDefault().isValid(project)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element configurationFragment = document.createElementNS(COVERAGE_NAMESPACE_URI, "coverage");
                configurationFragment.setAttribute("enabled", enabled ? "true" : "false");
                config.putConfigurationFragment(configurationFragment, false);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DOMException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static boolean isAggregating(Project project) {
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element configurationFragment = config.getConfigurationFragment("coverage", COVERAGE_NAMESPACE_URI, false);
        if (configurationFragment == null) {
            return false;
        }
        return configurationFragment.getAttribute("aggregating").equals("true");
    }

    public static void setAggregating(Project project, boolean aggregating) {
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        if (ProjectManager.getDefault().isValid(project)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element configurationFragment = document.createElementNS(COVERAGE_NAMESPACE_URI, "coverage");
                configurationFragment.setAttribute("aggregating", aggregating ? "true" : "false");
                config.putConfigurationFragment(configurationFragment, false);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DOMException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

