/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.cache;

import edu.berkeley.nlp.lm.AbstractContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.bits.BitUtils;
import edu.berkeley.nlp.lm.cache.ContextEncodedDirectMappedLmCache;
import edu.berkeley.nlp.lm.cache.ContextEncodedLmCache;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.MurmurHash;

public class ContextEncodedCachingLmWrapper<T>
extends AbstractContextEncodedNgramLanguageModel<T> {
    private static final long serialVersionUID = 1L;
    private final ContextEncodedLmCache contextCache;
    private final ContextEncodedNgramLanguageModel<T> lm;
    private final int capacity;

    public static <T> ContextEncodedCachingLmWrapper<T> wrapWithCacheNotThreadSafe(ContextEncodedNgramLanguageModel<T> lm) {
        return ContextEncodedCachingLmWrapper.wrapWithCacheNotThreadSafe(lm, 18);
    }

    public static <T> ContextEncodedCachingLmWrapper<T> wrapWithCacheNotThreadSafe(ContextEncodedNgramLanguageModel<T> lm, int cacheBits) {
        return new ContextEncodedCachingLmWrapper<T>(lm, false, cacheBits);
    }

    public static <T> ContextEncodedCachingLmWrapper<T> wrapWithCacheThreadSafe(ContextEncodedNgramLanguageModel<T> lm) {
        return ContextEncodedCachingLmWrapper.wrapWithCacheThreadSafe(lm, 16);
    }

    public static <T> ContextEncodedCachingLmWrapper<T> wrapWithCacheThreadSafe(ContextEncodedNgramLanguageModel<T> lm, int cacheBits) {
        return new ContextEncodedCachingLmWrapper<T>(lm, true, cacheBits);
    }

    private ContextEncodedCachingLmWrapper(ContextEncodedNgramLanguageModel<T> lm, boolean threadSafe, int cacheBits) {
        this(lm, new ContextEncodedDirectMappedLmCache(cacheBits, threadSafe));
    }

    private ContextEncodedCachingLmWrapper(ContextEncodedNgramLanguageModel<T> lm, ContextEncodedLmCache cache) {
        super(lm.getLmOrder(), lm.getWordIndexer(), Float.NaN);
        this.lm = lm;
        this.contextCache = cache;
        this.capacity = this.contextCache.capacity();
    }

    @Override
    public WordIndexer<T> getWordIndexer() {
        return this.lm.getWordIndexer();
    }

    @Override
    public ContextEncodedNgramLanguageModel.LmContextInfo getOffsetForNgram(int[] ngram, int startPos, int endPos) {
        return this.lm.getOffsetForNgram(ngram, startPos, endPos);
    }

    @Override
    public int[] getNgramForOffset(long contextOffset, int contextOrder, int word) {
        return this.lm.getNgramForOffset(contextOffset, contextOrder, word);
    }

    @Override
    public float getLogProb(long contextOffset, int contextOrder, int word, @Annotations.OutputParameter ContextEncodedNgramLanguageModel.LmContextInfo contextOutput) {
        if (contextOrder < 0) {
            return this.lm.getLogProb(contextOffset, contextOrder, word, contextOutput);
        }
        int hash = ContextEncodedCachingLmWrapper.hash(contextOffset, contextOrder, word) % this.capacity;
        float f = this.contextCache.getCached(contextOffset, contextOrder, word, hash, contextOutput);
        if (!Float.isNaN(f)) {
            return f;
        }
        f = this.lm.getLogProb(contextOffset, contextOrder, word, contextOutput);
        this.contextCache.putCached(contextOffset, contextOrder, word, f, hash, contextOutput);
        return f;
    }

    private static int hash(long contextOffset, int contextOrder, int word) {
        int hash = (int)MurmurHash.hashThreeLongs(contextOffset, contextOrder, word);
        return BitUtils.abs(hash);
    }
}

