/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.bspt.PointIterator;
import org.jmol.viewer.Viewer;

public class BZone {
    static String[] bzColors = new String[]{"red", "green", "skyblue", "orange", "yellow", "indigo", "violet"};
    boolean bzDrawPointsAndEdges = false;
    boolean bzSavePmeshes = false;
    private Lst<BZone> bzones = null;
    private P3 bzGamma = new P3();
    private Lst<P3> bzFaceCenters = null;
    private Lst<P3> bzLatticePts = null;
    private P3[] bzLatticePtsAll = null;
    private Lst<P3> bzPlanePts = null;
    private Lst<BZone> subzones = null;
    private boolean isWignerSeitz;
    private Viewer vwr;
    private JmolScriptEvaluator eval;
    private String id;
    private int index;
    private String color;
    private Lst<P3> latticePts;
    private Lst<P3> newLatticePts;
    private Lst<P3> newPlanePts;
    private Lst<P4> planes;
    private Lst<P4> newPlanes;
    private float volume = 0.0f;
    private int zoneIndex;
    private P3 offset;
    private P3 center;
    private Lst<P4> planesUnused;
    private Lst<P3> ptsUnused;
    private Lst<Object> pmeshes;
    private Lst<Double> areas;
    private Lst<P3[]> faces;
    private Lst<int[]> faceIndices;
    private Lst<P3> faceCenters;
    private double totalArea;
    private static P3 ptInner = P3.new3(Float.NaN, 0.0f, 0.0f);
    private Object[] ret = new Object[1];
    private String polyid;
    private P3[] pts;

    public BZone setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.eval = viewer.eval;
        return this;
    }

    public void createBZ(int n, Object[] objectArray, boolean bl, String string, float f) {
        if (this.vwr == null) {
            return;
        }
        if (objectArray != null) {
            this.demoBZ(objectArray, bl);
        } else {
            this.createAllBZs(n, true, string, f);
        }
    }

    public void createWS(String string) {
        if (this.vwr == null) {
            return;
        }
        this.createAllBZs(-1, false, string, 1.0f);
    }

    private void createAllBZs(int n, boolean bl, String string, float f) {
        this.cmd("unitcell reset");
        this.cmd("unitcell primitive");
        if (n < 0) {
            n = -n;
            this.isWignerSeitz = true;
        } else {
            if (n == 0) {
                n = 1;
            }
            if (Float.isNaN(f)) {
                f = 2.0f;
            }
            this.cmd("unitcell 'reciprocal' " + f);
        }
        this.cmd("polyhedra pbz* delete");
        this.cmd("pmesh fbz* delete");
        if (!this.isWignerSeitz) {
            this.cmd("axes unitcell; axes on; axes scale 2.0;axes 0.01;axes labels \"b1\" \"b2\" \"b3\" \"\"");
        }
        this.bzones = new Lst();
        this.bzLatticePts = new Lst();
        this.bzPlanePts = new Lst();
        this.bzFaceCenters = new Lst();
        boolean bl2 = this.vwr.getBoolean(603979875);
        this.vwr.setBooleanProperty("legacyJavaFloat", true);
        this.getLatticePoints(n);
        this.bzones.addLast(null);
        int n2 = 1;
        while (n2 <= n) {
            this.bzones.add(n2, this.newBZ(n2));
            this.createNextBZ((BZone)this.bzones.get(n2), (BZone)this.bzones.get(n2 - 1), string);
            if (bl && n2 > 1) {
                this.cmd("polyhedra id \"pbz" + (n2 - 1) + "_*\" delete");
            }
            ++n2;
        }
        this.vwr.setBooleanProperty("legacyJavaFloat", bl2);
        if (this.bzSavePmeshes) {
            this.cmd("polyhedra * off;pmesh * on;");
        }
    }

    private void createNextBZ(BZone bZone, BZone bZone2, String string) {
        this.getNewLatticePoints(bZone);
        if (this.bzDrawPointsAndEdges) {
            this.drawZoneCenters(bZone);
        }
        this.getSubzones(bZone, bZone2);
        int n = 0;
        while (n < bZone.subzones.size()) {
            BZone bZone3 = (BZone)bZone.subzones.get(n);
            if (this.getSubzonePmeshes(bZone3)) {
                if (this.bzDrawPointsAndEdges) {
                    this.drawSubzonePolygons(bZone3);
                }
                this.createSubzonePolyhedron(bZone3, string);
            }
            ++n;
        }
        this.finalizeZone(bZone);
    }

    private BZone newSubZone(BZone bZone, String string, int n) {
        BZone bZone2 = new BZone();
        bZone2.index = n;
        bZone2.id = String.valueOf(bZone.id) + string + n + "_";
        bZone2.zoneIndex = bZone.index;
        bZone2.newLatticePts = bZone.newLatticePts;
        bZone2.planes = new Lst();
        bZone2.latticePts = new Lst();
        bZone2.planesUnused = new Lst();
        bZone2.ptsUnused = new Lst();
        bZone2.pmeshes = new Lst();
        bZone2.areas = new Lst();
        bZone2.faces = new Lst();
        bZone2.faceIndices = new Lst();
        bZone2.faceCenters = new Lst();
        bZone2.volume = 0.0f;
        bZone2.color = bZone.color;
        bZone2.offset = new P3();
        bZone2.center = new P3();
        bZone.subzones.addLast(bZone2);
        return bZone2;
    }

    private void getSubzones(BZone bZone, BZone bZone2) {
        if (bZone.index == 1) {
            BZone bZone3 = this.newSubZone(bZone, "", 1);
            bZone3.latticePts = bZone.newLatticePts;
            bZone3.planes = bZone.newPlanes;
            return;
        }
        int n = 0;
        while (n < bZone2.subzones.size()) {
            int n2;
            Lst<P4> lst = bZone.newPlanes;
            Lst<P3> lst2 = bZone.newLatticePts;
            BZone bZone4 = (BZone)bZone2.subzones.get(n);
            Lst<P4> lst3 = bZone4.planes;
            Lst<P3> lst4 = bZone4.latticePts;
            Lst<P4> lst5 = bZone4.planesUnused;
            Lst<P3> lst6 = bZone4.ptsUnused;
            Lst<P3> lst7 = bZone4.faceCenters;
            String string = bZone4.id.substring(4);
            int n3 = n2 = bZone2.index == 1 ? 0 : 1;
            while (n3 < lst3.size()) {
                if (n2 != 1 || this.within(0.01f, (P3)lst7.get(n3), this.bzFaceCenters).size() <= 1) {
                    BZone bZone5 = this.newSubZone(bZone, string, n3 + 1);
                    this.addBZ(bZone5.planes, bZone5.latticePts, lst3, lst4, n3);
                    this.addBZ(bZone5.planes, bZone5.latticePts, lst5, lst6, -1);
                    this.addBZ(bZone5.planes, bZone5.latticePts, lst, lst2, -1);
                }
                ++n3;
            }
            ++n;
        }
    }

    private void addBZ(Lst<P4> lst, Lst<P3> lst2, Lst<P4> lst3, Lst<P3> lst4, int n) {
        if (n >= 0) {
            P4 p4 = P4.newPt((P4)lst3.get(n));
            p4.scale4(-1.0f);
            lst.addLast(p4);
            lst2.addLast((P3)lst4.get(n));
        }
        int n2 = lst3.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n) {
                lst.addLast((P4)lst3.get(n3));
                lst2.addLast((P3)lst4.get(n3));
            }
            ++n3;
        }
    }

    private void getNewLatticePoints(BZone bZone) {
        Lst lst = new Lst();
        Lst lst2 = new Lst();
        Lst<P3> lst3 = bZone.newPlanePts;
        Lst<P3> lst4 = bZone.newLatticePts;
        Lst<P4> lst5 = bZone.newPlanes;
        int n = 0;
        while (n < this.bzPlanePts.size()) {
            Lst<P3> lst6;
            Lst<P3> lst7;
            P3 p3 = (P3)this.bzPlanePts.get(n);
            P3 p32 = P3.newP(p3);
            p32.scale(0.5f);
            float f = 0.501f * p3.length();
            Lst<P3> lst8 = this.within(f, p32, this.bzPlanePts);
            if (lst8.size() == 1) {
                lst7 = lst3;
                lst6 = lst4;
                lst5.addLast(this.plane(this.bzGamma, p3, 1.0f));
            } else {
                lst7 = lst;
                lst6 = lst2;
            }
            lst7.addLast(p3);
            lst6.addLast((P3)this.bzLatticePts.get(n));
            ++n;
        }
        this.bzPlanePts = lst;
        this.bzLatticePts = lst2;
    }

    private P4 plane(P3 p3, P3 p32, float f) {
        V3 v3 = V3.newVsub(p32, p3);
        P3 p33 = new P3();
        p33.scaleAdd2(f, v3, p3);
        P4 p4 = new P4();
        Measure.getPlaneThroughPoint(p33, v3, p4);
        return p4;
    }

    private Lst<P3> within(float f, P3 p3, Lst<P3> lst) {
        Lst<P3> lst2 = new Lst<P3>();
        float f2 = f * f;
        int n = 0;
        int n2 = lst.size();
        while (n < n2) {
            P3 p32 = (P3)lst.get(n);
            if (p3.distanceSquared(p32) < f2) {
                lst2.addLast(p32);
            }
            ++n;
        }
        return lst2;
    }

    private BZone newBZ(int n) {
        BZone bZone = new BZone();
        bZone.id = "bz" + n + "_";
        bZone.index = n;
        bZone.color = this.bzColor(n);
        bZone.subzones = new Lst();
        bZone.newLatticePts = new Lst();
        bZone.newPlanePts = new Lst();
        bZone.newPlanes = new Lst();
        bZone.volume = 0.0f;
        return bZone;
    }

    private String bzColor(int n) {
        return bzColors[(n - 1) % bzColors.length];
    }

    private void getLatticePoints(int n) {
        int n2;
        int[][] nArray = new int[3][3];
        P3 p3 = new P3();
        float[] fArray = new float[]{this.newPoint(1, 0, 0, p3).length(), this.newPoint(0, 1, 0, p3).length(), this.newPoint(0, 0, 1, p3).length()};
        float f = Math.max(fArray[0], Math.max(fArray[1], fArray[2]));
        int n3 = 0;
        while (n3 < 3) {
            n2 = (int)((float)n * f / fArray[n3]);
            nArray[n3] = new int[]{-n2, n2};
            ++n3;
        }
        Lst<P3> lst = new Lst<P3>();
        n2 = nArray[0][0];
        while (n2 <= nArray[0][1]) {
            int n4 = nArray[1][0];
            while (n4 <= nArray[1][1]) {
                int n5 = nArray[2][0];
                while (n5 <= nArray[2][1]) {
                    if (n2 != 0 || n4 != 0 || n5 != 0) {
                        P3 p32 = this.newPoint(n2, n4, n5, new P3());
                        lst.addLast(P3.newP(p32));
                        this.bzLatticePts.addLast(p32);
                        P3 p33 = P3.newP(p32);
                        p33.scale(0.5f);
                        this.bzPlanePts.addLast(p33);
                        System.out.println("draw ID 'pt" + n2 + n4 + n5 + "' " + p32);
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n2;
        }
        this.bzLatticePtsAll = lst.toArray(new P3[lst.size()]);
    }

    private P3 newPoint(int n, int n2, int n3, P3 p3) {
        p3.x = n;
        p3.y = n2;
        p3.z = n3;
        this.vwr.toCartesian(p3, false);
        return p3;
    }

    private void cmd(String string) {
        System.out.println(string);
        try {
            this.eval.runScript(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void demoBZ(Object[] objectArray, boolean bl) {
    }

    private boolean getSubzonePmeshes(BZone bZone) {
        this.planes = bZone.planes;
        this.latticePts = bZone.latticePts;
        this.planesUnused = bZone.planesUnused;
        this.ptsUnused = bZone.ptsUnused;
        this.faces = bZone.faces;
        this.faceCenters = bZone.faceCenters;
        int n = this.planes.size();
        Lst<P4> lst = new Lst<P4>();
        Lst<P3> lst2 = new Lst<P3>();
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray;
            String string = "f" + bZone.id + n2;
            this.cmd("pmesh ID " + string + " silent resolution 0.001 boundingbox {-2/1 -2/1 -2/1} {2/1 2/1 2/1} plane   " + this.toScript((P4)this.planes.get(n2)) + " off");
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < n) {
                if (n3 != n2) {
                    this.cmd("pmesh slab plane " + this.toScript((P4)this.planes.get(n3)));
                    objectArray = (double[])this.getProperty(string, "area");
                    double d3 = d2 = objectArray == null ? 0.0 : (double)objectArray[0];
                    if (d2 == 0.0) break;
                    d += d2;
                }
                ++n3;
            }
            P3 p3 = null;
            objectArray = null;
            if (d2 > 0.0) {
                objectArray = (P3[])this.getProperty(string, "face");
                p3 = this.average((P3[])objectArray);
                if (n2 == 0 && this.within(0.01f, p3, this.bzFaceCenters).size() >= 2) {
                    d2 = 0.0;
                    d = 0.0;
                    n2 = n;
                }
            }
            if (d2 > 0.0) {
                this.faces.addLast(this.cleanFace((P3[])objectArray));
                this.faceCenters.addLast(p3);
                this.bzFaceCenters.addLast(p3);
                if (this.bzSavePmeshes) {
                    bZone.pmeshes.addLast(string);
                } else {
                    this.cmd("pmesh ID " + string + " delete");
                }
                lst.addLast((P4)this.planes.get(n2));
                lst2.addLast((P3)this.latticePts.get(n2));
                bZone.areas.addLast(d2);
            } else {
                this.cmd("pmesh ID " + string + " delete");
                this.planesUnused.addLast((P4)this.planes.get(n2));
                this.ptsUnused.addLast((P3)this.latticePts.get(n2));
            }
            bZone.planes = lst;
            bZone.latticePts = lst2;
            ++n2;
        }
        bZone.totalArea = d;
        return d > 0.0;
    }

    private String toScript(P4 p4) {
        return "{" + p4.x + " " + p4.y + " " + p4.z + " " + p4.w + "}";
    }

    private Object getProperty(String string, String string2) {
        Object[] objectArray = new Object[3];
        int n = this.vwr.shm.getShapeIdFromObjectName(string);
        if (n >= 0) {
            objectArray[0] = string;
            this.vwr.shm.getShapePropertyData(n, "index", objectArray);
            if (objectArray[1] != null && !string2.equals("index")) {
                int n2 = (Integer)objectArray[1];
                objectArray[1] = this.vwr.shm.getShapePropertyIndex(n, string2.intern(), n2);
            }
        }
        return objectArray[1];
    }

    private void createSubzonePolyhedron(BZone bZone, String string) {
        if (string == null) {
            string = "p" + bZone.id;
        }
        bZone.polyid = string;
        P3[] p3Array = this.join(bZone.faces);
        P3[] p3Array2 = this.cleanFace(p3Array);
        bZone.pts = p3Array2;
        bZone.center = this.average(p3Array2);
        bZone.offset = this.closest(bZone.center, this.bzLatticePtsAll);
        Lst<int[]> lst = bZone.faceIndices = new Lst();
        Lst<P3[]> lst2 = bZone.faces;
        int n = 0;
        int n2 = lst2.size();
        while (n < n2) {
            lst.addLast(this.faceIndices((P3[])lst2.get(n), p3Array2));
            ++n;
        }
        n = lst.size();
        while (--n >= 0) {
            if (((int[])lst.get(n)).length >= 3) continue;
            bZone.faces.removeItemAt(n);
            bZone.faceIndices.removeItemAt(n);
            bZone.faceCenters.removeItemAt(n);
            bZone.planes.removeItemAt(n);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", string);
        hashtable.put("center", bZone.center);
        Lst<P3> lst3 = new Lst<P3>();
        int n3 = 0;
        int n4 = p3Array2.length;
        while (n3 < n4) {
            lst3.addLast(p3Array2[n3]);
            ++n3;
        }
        hashtable.put("vertices", lst3);
        hashtable.put("faces", lst);
        hashtable.put("color", bZone.color);
        this.vwr.setShapeProperty(21, "init", Boolean.TRUE);
        this.vwr.setShapeProperty(21, "info", hashtable);
        this.vwr.setShapeProperty(21, "generate", null);
        this.vwr.setShapeProperty(21, "init", Boolean.FALSE);
        if (this.bzDrawPointsAndEdges) {
            this.cmd("color $" + string + " translucent");
            this.cmd("draw pts points " + p3Array2 + " dots nofill nomesh");
        }
    }

    private int[] faceIndices(P3[] p3Array, P3[] p3Array2) {
        PointIterator.withinDistPoints(0.0f, null, p3Array2, p3Array, this.ret);
        return (int[])this.ret[0];
    }

    private P3 closest(P3 p3, P3[] p3Array) {
        PointIterator.withinDistPoints(0.0f, p3, p3Array, null, this.ret);
        return (P3)this.ret[0];
    }

    private P3[] cleanFace(P3[] p3Array) {
        PointIterator.withinDistPoints(0.01f, ptInner, p3Array, null, this.ret);
        Lst lst = (Lst)this.ret[0];
        return lst.toArray(new P3[lst.size()]);
    }

    private P3 average(P3[] p3Array) {
        P3 p3 = new P3();
        int n = p3Array.length;
        while (--n >= 0) {
            p3.add(p3Array[n]);
        }
        p3.scale(1.0f / (float)p3Array.length);
        return p3;
    }

    private P3[] join(Lst<P3[]> lst) {
        int n = 0;
        int n2 = lst.size();
        while (--n2 >= 0) {
            n += ((P3[])lst.get(n2)).length;
        }
        P3[] p3Array = new P3[n];
        n = 0;
        int n3 = lst.size();
        while (--n3 >= 0) {
            P3[] p3Array2 = (P3[])lst.get(n3);
            int n4 = p3Array2.length;
            while (--n4 >= 0) {
                p3Array[n++] = p3Array2[n4];
            }
        }
        return p3Array;
    }

    private void drawZoneCenters(BZone bZone) {
    }

    private void drawSubzonePolygons(BZone bZone) {
    }

    private void finalizeZone(BZone bZone) {
        int n = bZone.subzones.size();
        while (--n >= 0) {
            if (((BZone)bZone.subzones.get((int)n)).totalArea != 0.0) continue;
            bZone.subzones.removeItemAt(n);
        }
    }
}

