#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 1.2.7
id: dbus-1.2.7-D7o4wluQHKHLRqtOAzsNS3
key: dbus-1.2.7-D7o4wluQHKHLRqtOAzsNS3
license: Apache-2.0
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>
author: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
abi: 971dcfa52267bd3295756a5fb35410ff
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport
import-dirs: /usr/lib/ghc-8.6.5/site-local/dbus-1.2.7
library-dirs: /usr/lib/ghc-8.6.5/site-local/dbus-1.2.7
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/dbus-1.2.7
hs-libraries: HSdbus-1.2.7-D7o4wluQHKHLRqtOAzsNS3
depends:
    base-4.12.0.0 bytestring-0.10.8.2
    cereal-0.5.8.0-DifhRWa8By0JYDe2id7eOT
    conduit-1.3.1.1-Fm1W7uNei6OKfQ1DCXNTzR containers-0.6.0.1
    deepseq-1.4.4.0 exceptions-0.10.2-38lh9z3oeQXEUP64sSuIJH
    filepath-1.4.2.1 lens-4.17.1-D6OjOdeP0MqEPqDMoHvH3T
    network-2.8.0.0-A0G1UJzDIGiEvzFah0DnI2 parsec-3.1.13.0
    random-1.1-3ypV4EIycgb35PKjTYYr5q
    split-0.2.3.3-DmDMlgWSMW26OczFIiZ5Gr template-haskell-2.14.0.0
    text-1.2.3.1 th-lift-0.7.11-hZJVZ2zmXw59mRAYP9RXW
    transformers-0.5.6.2 unix-2.7.2.2
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
    xml-conduit-1.8.0.1-7eCzT8UL87gBol5kv4fZYX
    xml-types-0.3.6-56MQ2lbfiw31ognZ51DOah
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

