/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import org.gradle.internal.component.external.model.CapabilityInternal;

public class ImmutableCapability
implements CapabilityInternal {
    private final String group;
    private final String name;
    private final String version;
    private final int hashCode;
    private final String cachedId;

    public ImmutableCapability(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, name, group});
        this.cachedId = group + ":" + name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCapability that = (ImmutableCapability)o;
        return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "capability group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'';
    }

    @Override
    public String getCapabilityId() {
        return this.cachedId;
    }
}

