/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.utils.ColorShiftFilter;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

public class BasicRibbonTaskToggleButtonUI
extends BasicCommandToggleButtonUI {
    protected PopupPanelManager.PopupListener popupListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonTaskToggleButtonUI();
    }

    @Override
    protected void installDefaults() {
        Border border;
        super.installDefaults();
        Font f = this.commandButton.getFont();
        if (f == null || f instanceof UIResource) {
            this.commandButton.setFont(FlamingoUtilities.getFont(null, "Ribbon.font", "Button.font", "Panel.font"));
        }
        if ((border = this.commandButton.getBorder()) == null || border instanceof UIResource) {
            Border toInstall = UIManager.getBorder("RibbonTaskToggleButton.border");
            if (toInstall == null) {
                toInstall = new BorderUIResource.EmptyBorderUIResource(1, 12, 1, 12);
            }
            this.commandButton.setBorder(toInstall);
        }
        this.commandButton.setFlat(true);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            private boolean isTaskSelected() {
                JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, BasicRibbonTaskToggleButtonUI.this.commandButton);
                if (ribbon == null) {
                    return false;
                }
                return ribbon.getSelectedTask() == ((JRibbonTaskToggleButton)BasicRibbonTaskToggleButtonUI.this.commandButton).getRibbonTask();
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
    }

    @Override
    protected void uninstallListeners() {
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight() + 10));
        this.paintText(g2d);
        g2d.dispose();
    }

    protected void paintText(Graphics g) {
        int strWidth;
        FontMetrics fm = g.getFontMetrics();
        String toPaint = this.commandButton.getText();
        int fullInsets = this.commandButton.getInsets().left;
        int pw = this.getPreferredSize((JComponent)this.commandButton).width;
        int mw = this.getMinimumSize((JComponent)this.commandButton).width;
        int w = this.commandButton.getWidth();
        int h = this.commandButton.getHeight();
        int insets = fullInsets - (pw - w) * (fullInsets - 2) / (pw - mw);
        Rectangle textRect = new Rectangle(insets, 1 + (h - fm.getHeight()) / 2, w - 2 * insets, fm.getHeight());
        while (toPaint.length() != 0 && (strWidth = fm.stringWidth(toPaint)) > textRect.width) {
            toPaint = toPaint.substring(0, toPaint.length() - 1);
        }
        BasicGraphicsUtils.drawString(g, toPaint, -1, textRect.x, textRect.y + fm.getAscent());
    }

    @Override
    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, this.commandButton);
        this.buttonRendererPane.setBounds(toFill.x, toFill.y, toFill.width, toFill.height);
        ButtonModel model = this.rendererButton.getModel();
        model.setEnabled(this.commandButton.isEnabled());
        model.setSelected(false);
        boolean displayAsSelected = this.commandButton.getActionModel().isSelected();
        model.setRollover(displayAsSelected || this.commandButton.getActionModel().isRollover());
        model.setPressed(false);
        if (model.isRollover()) {
            boolean isContextualTask;
            Graphics2D g2d = (Graphics2D)graphics.create();
            if (!this.commandButton.getActionModel().isSelected()) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.4f));
            }
            g2d.translate(toFill.x, toFill.y);
            Color contextualGroupHueColor = ((JRibbonTaskToggleButton)this.commandButton).getContextualGroupHueColor();
            boolean bl = isContextualTask = contextualGroupHueColor != null;
            if (!isContextualTask) {
                Shape clip = g2d.getClip();
                g2d.clip(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height, 2.0f));
                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - toFill.width / 2, toFill.y - toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
                g2d.setColor(FlamingoUtilities.getBorderColor().darker());
                g2d.setClip(clip);
                g2d.draw(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height + 1, 2.0f));
            } else {
                BufferedImage offscreen = FlamingoUtilities.getBlankImage(toFill.width, toFill.height);
                Graphics2D offscreenGraphics = offscreen.createGraphics();
                Shape clip = g2d.getClip();
                offscreenGraphics.clip(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height, 2.0f));
                this.buttonRendererPane.paintComponent(offscreenGraphics, this.rendererButton, this.commandButton, toFill.x - toFill.width / 2, toFill.y - toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
                offscreenGraphics.setColor(FlamingoUtilities.getBorderColor().darker());
                offscreenGraphics.setClip(clip);
                offscreenGraphics.draw(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height + 1, 2.0f));
                offscreenGraphics.dispose();
                ColorShiftFilter filter = new ColorShiftFilter(contextualGroupHueColor, 0.25);
                BufferedImage colorized = filter.filter(offscreen, null);
                g2d.drawImage((Image)colorized, 0, 0, null);
            }
            g2d.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JRibbonTaskToggleButton b = (JRibbonTaskToggleButton)c;
        ResizableIcon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, 0, b.getHorizontalAlignment(), 0, 0, viewR, iconR, textR, text == null ? 0 : 6);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JRibbonTaskToggleButton b = (JRibbonTaskToggleButton)c;
        ResizableIcon icon = b.getIcon();
        String text = "Www";
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, 0, b.getHorizontalAlignment(), 0, 0, viewR, iconR, textR, text == null ? 0 : 6);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += 4;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }
}

