/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
#include"getput.h"
#include"datei.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: free_bravais.
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ void free_bravais(grp)
@ bravais_TYP *grp;
@
@ frees the space allocated for the pointers of the bravais_TYP *grp.
@---------------------------------------------------------------------------
@
\**************************************************************************/

void free_bravais(grp)
bravais_TYP *grp;
{
int i;

  if ( grp ) {
    if ( grp->gen_no != 0 &&  grp->gen ) {
      for(i=0; i< grp->gen_no; i++) {
          free_mat(grp->gen[i]);
      }  
      free ( grp->gen );
    }
    
    if ( grp->form_no != 0 && grp->form ) {
      for(i=0; i< grp->form_no; i++) {
          free_mat(grp->form[i]);
      }
      free( (int *)grp->form);
    }
    
    if ( grp->zentr_no != 0  && grp->zentr ) {
      for(i=0; i< grp->zentr_no; i++)
      {
          free_mat(grp->zentr[i]);
      }
      free( (int *)grp->zentr);
    }
      
    if ( grp->normal_no != 0  && grp->normal ) {
      for(i=0; i< grp->normal_no; i++)
      {
          free_mat(grp->normal[i]);
      }
      free( (int *)grp->normal);
    }
    
    if ( grp->cen_no != 0  && grp->cen ) {
      for(i=0; i< grp->cen_no; i++)
      {
        free_mat(grp->cen[i]);
      }
      free( (int *)grp->cen );
    }

    free( (int *)grp);
  }

}


/*{{{}}}*/
