/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SymbolsLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IEclipsePreferences.IPreferenceChangeListener {
    private Map<Image, Image[]> overlays = new HashMap<Image, Image[]>();
    private boolean showLocation;
    private boolean showKind;

    public SymbolsLabelProvider() {
        this(false, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
    }

    public SymbolsLabelProvider(boolean showLocation, boolean showKind) {
        this.showLocation = showLocation;
        this.showKind = showKind;
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void dispose() {
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        if (element instanceof Throwable) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof Either) {
            element = ((Either)element).get();
        }
        Image res = null;
        if (element instanceof SymbolInformation) {
            res = LSPImages.imageFromSymbolKind(((SymbolInformation)element).getKind());
        } else if (element instanceof DocumentSymbol) {
            res = LSPImages.imageFromSymbolKind(((DocumentSymbol)element).getKind());
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            res = LSPImages.imageFromSymbolKind(((SymbolsModel.DocumentSymbolWithFile)element).symbol.getKind());
        }
        IResource file = null;
        if (element instanceof SymbolInformation) {
            file = LSPEclipseUtils.findResourceFor(((SymbolInformation)element).getLocation().getUri());
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            file = ((SymbolsModel.DocumentSymbolWithFile)element).file;
        }
        if (file != null) {
            Range range = null;
            if (element instanceof SymbolInformation) {
                range = ((SymbolInformation)element).getLocation().getRange();
            } else if (element instanceof DocumentSymbol) {
                range = ((DocumentSymbol)element).getRange();
            } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
                range = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getRange();
            }
            if (range != null) {
                try {
                    int maxSeverity = this.getMaxSeverity(file, range);
                    if (maxSeverity > 0) {
                        return this.getOverlay(res, maxSeverity);
                    }
                }
                catch (CoreException | BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return res;
    }

    protected int getMaxSeverity(IResource resource, Range range) throws CoreException, BadLocationException {
        IDocument doc = LSPEclipseUtils.getDocument(resource);
        int maxSeverity = -1;
        IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            int offset = marker.getAttribute("charStart", -1);
            if (offset != -1 && offset >= LSPEclipseUtils.toOffset(range.getStart(), doc) && offset <= LSPEclipseUtils.toOffset(range.getEnd(), doc)) {
                maxSeverity = Math.max(maxSeverity, marker.getAttribute("severity", -1));
            }
            ++n2;
        }
        return maxSeverity;
    }

    private Image getOverlay(Image res, int maxSeverity) {
        Image[] currentOverlays;
        if (maxSeverity != 1 && maxSeverity != 2) {
            throw new IllegalArgumentException("Severity " + maxSeverity + " not supported.");
        }
        if (!this.overlays.containsKey(res)) {
            this.overlays.put(res, new Image[2]);
        }
        if ((currentOverlays = this.overlays.get(res))[maxSeverity - 1] == null) {
            String overlayId = null;
            if (maxSeverity == 2) {
                overlayId = "IMG_DEC_FIELD_ERROR";
            } else if (maxSeverity == 1) {
                overlayId = "IMG_DEC_FIELD_WARNING";
            }
            currentOverlays[maxSeverity - 1] = new DecorationOverlayIcon(res, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(overlayId), 2).createImage();
        }
        return currentOverlays[maxSeverity - 1];
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return new StyledString(Messages.outline_computingSymbols);
        }
        if (element instanceof Throwable) {
            String message = ((Throwable)element).getMessage();
            if (message == null) {
                message = element.getClass().getName();
            }
            return new StyledString(message);
        }
        if (element instanceof LanguageServiceAccessor.LSPDocumentInfo) {
            return new StyledString(((LanguageServiceAccessor.LSPDocumentInfo)element).getFileUri().getPath());
        }
        StyledString res = new StyledString();
        if (element == null) {
            return res;
        }
        if (element instanceof Either) {
            element = ((Either)element).get();
        }
        String name = null;
        SymbolKind kind = null;
        URI location = null;
        if (element instanceof SymbolInformation) {
            name = ((SymbolInformation)element).getName();
            kind = ((SymbolInformation)element).getKind();
            location = URI.create(((SymbolInformation)element).getLocation().getUri());
        } else if (element instanceof DocumentSymbol) {
            name = ((DocumentSymbol)element).getName();
            kind = ((DocumentSymbol)element).getKind();
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            name = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getName();
            kind = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getKind();
            location = ((SymbolsModel.DocumentSymbolWithFile)element).file.getLocationURI();
        }
        if (name != null) {
            res.append(name, null);
        }
        if (this.showKind && kind != null) {
            res.append(" :", null);
            res.append(kind.toString(), StyledString.DECORATIONS_STYLER);
        }
        if (this.showLocation && location != null) {
            res.append(' ');
            res.append(location.getPath(), StyledString.QUALIFIER_STYLER);
        }
        return res;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.lsp4e.outline.showKind")) {
            this.showKind = Boolean.valueOf(event.getNewValue().toString());
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof ILabelProviderListener) {
                    ((ILabelProviderListener)listener).labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
                }
                ++n2;
            }
        }
    }
}

