/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.LinkedList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.pathmapper.IPathEntryFilter;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;
import org.eclipse.php.internal.debug.ui.pathmapper.PathEntrySelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PathEntrySelector
implements IPathEntryFilter {
    public PathEntry[] filter(final PathEntry[] entries, final VirtualPath remotePath, final IDebugTarget debugTarget) {
        final LinkedList l = new LinkedList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PathEntry entry;
                Shell shell = Display.getDefault().getActiveShell();
                if (shell == null) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        window = windows[0];
                    }
                    if (window != null) {
                        shell = window.getShell();
                    }
                }
                if ((entry = PathEntrySelector.this.runFilterDialog(shell, remotePath, entries, debugTarget)) != null) {
                    l.add(entry);
                }
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            Display.getDefault().syncExec(r);
        }
        return l.toArray(new PathEntry[l.size()]);
    }

    protected PathEntrySelectionDialog createSelectionDialog(Shell shell, VirtualPath remotePath, PathEntry[] entries) {
        return new PathEntrySelectionDialog(shell, remotePath, entries);
    }

    protected PathEntry runFilterDialog(Shell shell, VirtualPath remotePath, PathEntry[] entries, IDebugTarget debugTarget) {
        PathEntrySelectionDialog selectDialog = this.createSelectionDialog(shell, remotePath, entries);
        if (shell != null) {
            shell.forceActive();
            shell.setActive();
        }
        if (selectDialog.open() == 0) {
            PathEntry result = selectDialog.getResult();
            if (result != null) {
                return result;
            }
            VirtualPath ignorePath = selectDialog.getIgnoreResult();
            result = new PathEntry(ignorePath, PathEntry.Type.SERVER, null);
            if (debugTarget instanceof PHPDebugTarget) {
                PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
                phpDebugTarget.getContextManager().addToResolveBlacklist(ignorePath, ResolveBlackList.Type.RECURSIVE);
            }
            return result;
        }
        try {
            debugTarget.terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }
}

