/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.PrimitiveOperation;

public class NumberLiteral
extends Expression {
    protected String numberString = "";
    protected boolean isComplete = false;
    protected Class numberClass = Integer.TYPE;
    protected int exponentFlag = 0;
    protected static final int NO_EXPONENT = 0;
    protected static final int HAS_EXPONENT = 1;
    protected static final int HAS_EXPONENT_MINUS = 2;

    public Object evaluate() throws Exception {
        try {
            if (this.numberClass == Float.TYPE) {
                return new Float(Float.parseFloat(this.numberString));
            }
            if (this.numberClass == Long.TYPE) {
                return Long.decode(this.numberString);
            }
            if (this.numberClass == Double.TYPE) {
                return new Double(Double.parseDouble(this.numberString));
            }
            return Integer.decode(this.numberString);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public Class getTypeClass() {
        return this.numberClass;
    }

    protected String getTypeClassName() {
        return this.numberClass != null ? this.numberClass.getName() : "";
    }

    public Expression push(char[] token, char delimiter) {
        if (delimiter == ')' || delimiter == ',' || delimiter == '}') {
            this.isComplete = true;
        }
        if (delimiter == '-' && this.numberString.length() == 0) {
            this.numberString = String.valueOf(this.numberString) + '-';
        }
        this.numberString = String.valueOf(this.numberString) + this.processNumberToken(token);
        if (this.numberString.length() > 0 && token.length > 1) {
            switch (delimiter) {
                case '-': {
                    if (this.exponentFlag == 1) {
                        this.exponentFlag = 2;
                        this.numberString = String.valueOf(this.numberString) + '-';
                        break;
                    }
                }
                case '*': 
                case '+': 
                case '/': {
                    throw new RuntimeException("Can't do arithmetic yet");
                }
            }
        }
        if (delimiter == '.') {
            this.numberClass = Double.TYPE;
            this.numberString = String.valueOf(this.numberString) + '.';
        }
        if (delimiter == '|' || delimiter == '&') {
            PrimitiveOperation result = new PrimitiveOperation(this, delimiter);
            this.isComplete = true;
            return result;
        }
        return this;
    }

    protected String processNumberToken(char[] token) {
        int i = 0;
        while (i < token.length) {
            if (token[i] == 'E' || token[i] == 'e') {
                this.numberClass = Double.TYPE;
                this.exponentFlag = 1;
                break;
            }
            ++i;
        }
        char[] numberToken = token;
        if (token.length > 0) {
            switch (token[token.length - 1]) {
                case 'F': 
                case 'f': {
                    this.numberClass = Float.TYPE;
                    numberToken = new char[token.length - 1];
                    System.arraycopy(token, 0, numberToken, 0, numberToken.length);
                    this.isComplete = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    this.numberClass = Long.TYPE;
                    numberToken = new char[token.length - 1];
                    System.arraycopy(token, 0, numberToken, 0, numberToken.length);
                    this.isComplete = true;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.numberClass = Double.TYPE;
                    numberToken = new char[token.length - 1];
                    System.arraycopy(token, 0, numberToken, 0, numberToken.length);
                    this.isComplete = true;
                }
            }
        }
        return new String(numberToken);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Number \"");
        writer.write(this.numberString);
        writer.write("\"");
        return writer.toString();
    }

    public boolean isPrimitive() {
        return true;
    }
}

