/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseCheckConstraint;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseForeignKey;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBasePrimaryKey;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.TableASABaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public abstract class BaseTableASABaseLoader
extends TableASABaseLoader {
    protected BaseTable baseTable;
    public static final String PRIMARY_KEY_TYPE = "P";
    public static final String UNIQUE_CONSTRAINT_TYPE = "U";
    public static final String FOREIGN_KEY_TYPE = "F";
    public static final String TABLE_CHECK_CONSTRAINT_TYPE = "T";
    public static final String COLUMN_CHECK_CONSTRAINT_TYPE = "C";

    public BaseTableASABaseLoader(BaseTable catalogTable) {
        super((Table)catalogTable);
        this.baseTable = catalogTable;
    }

    public final void loadConstraints(EList constraintContainmentList) {
        try {
            boolean deliver = this.baseTable.eDeliver();
            this.baseTable.eSetDeliver(false);
            ArrayList existingConstraintList = new ArrayList(constraintContainmentList.size());
            existingConstraintList.addAll(constraintContainmentList);
            constraintContainmentList.clear();
            PrimaryKey loadedPK = this.loadPrimaryKey(existingConstraintList);
            if (loadedPK != null) {
                constraintContainmentList.add((Object)loadedPK);
            }
            constraintContainmentList.addAll((Collection)this.loadConstraints(existingConstraintList, UNIQUE_CONSTRAINT_TYPE));
            constraintContainmentList.addAll((Collection)this.loadConstraints(existingConstraintList, FOREIGN_KEY_TYPE));
            constraintContainmentList.addAll((Collection)this.loadConstraints(existingConstraintList, TABLE_CHECK_CONSTRAINT_TYPE));
            constraintContainmentList.addAll((Collection)this.loadColumnCheckConstraints());
            int i = 0;
            while (i < constraintContainmentList.size()) {
                ICatalogObject constraint = (ICatalogObject)constraintContainmentList.get(i);
                constraint.refresh();
                ++i;
            }
            this.baseTable.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    protected List loadColumnCheckConstraints() {
        ArrayList results = new ArrayList();
        EList columns = this.baseTable.getColumns();
        int i = 0;
        while (i < columns.size()) {
            SybaseASABaseColumn column = (SybaseASABaseColumn)columns.get(i);
            EList checks = column.getColumnConstraint();
            results.addAll(checks);
            ++i;
        }
        return results;
    }

    protected PrimaryKey loadPrimaryKey(List existingConstraintList) {
        PrimaryKey result;
        block9: {
            result = null;
            Connection conn = this.catalogObj.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    String schemaName = this.baseTable.getSchema().getName();
                    String tableName = this.baseTable.getName();
                    stmt = conn.prepareStatement(SQLScriptsProvider.getQueryConstraintsScript(this.catalogObj.getCatalogDatabase()));
                    stmt.setString(1, PRIMARY_KEY_TYPE);
                    stmt.setString(2, tableName);
                    stmt.setString(3, schemaName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String pkName = rs.getString(1);
                        PrimaryKey pk = (PrimaryKey)SybaseASACatalogUtils.findElement(existingConstraintList, pkName, SQLConstraintsPackage.eINSTANCE.getPrimaryKey());
                        if (pk == null || !pk.getName().equals(pkName)) {
                            result = this.createCatalogPrimaryKey();
                            result.setName(pkName);
                            continue;
                        }
                        result = pk;
                    }
                    int i = 0;
                    while (i < existingConstraintList.size()) {
                        Object constraint = existingConstraintList.get(i);
                        if (constraint instanceof PrimaryKey) {
                            existingConstraintList.remove(constraint);
                            break;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        return result;
    }

    protected PrimaryKey createCatalogPrimaryKey() {
        return new SybaseASACatalogBasePrimaryKey();
    }

    protected List loadConstraints(List existingConstrs, String constrType) {
        ArrayList<SQLObject> result;
        block14: {
            result = new ArrayList<SQLObject>();
            Connection conn = this.catalogObj.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    String schemaName = this.baseTable.getSchema().getName();
                    String tableName = this.baseTable.getName();
                    stmt = conn.prepareStatement(SQLScriptsProvider.getQueryConstraintsScript((Database)((SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase())));
                    stmt.setString(1, constrType);
                    stmt.setString(2, tableName);
                    stmt.setString(3, schemaName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String constrName = rs.getString(1);
                        SQLObject constraint = null;
                        constraint = constrType.equals(TABLE_CHECK_CONSTRAINT_TYPE) ? (SQLObject)SybaseASACatalogUtils.findElement(existingConstrs, constrName, SQLConstraintsPackage.eINSTANCE.getCheckConstraint()) : (constrType.equals(UNIQUE_CONSTRAINT_TYPE) ? (SQLObject)SybaseASACatalogUtils.findElement(existingConstrs, constrName, SQLConstraintsPackage.eINSTANCE.getUniqueConstraint()) : (SQLObject)SybaseASACatalogUtils.findElement(existingConstrs, constrName, SQLConstraintsPackage.eINSTANCE.getForeignKey()));
                        if (constraint == null) {
                            if (constrType.equals(UNIQUE_CONSTRAINT_TYPE)) {
                                constraint = this.createCatalogUniqueConstraint();
                            } else if (constrType.equals(FOREIGN_KEY_TYPE)) {
                                constraint = this.createCatalogForeignKey();
                            } else if (constrType.equals(TABLE_CHECK_CONSTRAINT_TYPE)) {
                                constraint = this.createCatalogTableCheckConstraint();
                            } else if (constrType.equals(COLUMN_CHECK_CONSTRAINT_TYPE)) {
                                constraint = this.createCatalogColumnCheckConstraint();
                            }
                            constraint.setName(constrName);
                        }
                        result.add(constraint);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        return result;
    }

    protected UniqueConstraint createCatalogUniqueConstraint() {
        return new SybaseASACatalogBaseUniqueConstraint();
    }

    protected ForeignKey createCatalogForeignKey() {
        return new SybaseASACatalogBaseForeignKey();
    }

    protected CheckConstraint createCatalogTableCheckConstraint() {
        return new SybaseASACatalogBaseCheckConstraint();
    }

    protected CheckConstraint createCatalogColumnCheckConstraint() {
        return new SybaseASACatalogBaseColumnCheckConstraint();
    }
}

