/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCopyFrom;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyFromContainerCommandHandler
extends AbstractHandler {
    private static final String ERROR_COPYING_FROM_CONTAINER_NO_CONNECTION = "command.copyfromcontainer.failure.no_connection";
    private static final String MISSING_CONNECTION = "missing_connection";
    private static final String ERROR_COPYING_FROM_CONTAINER = "command.copyfromcontainer.error.msg";
    private static final String COPY_FROM_CONTAINER_JOB_TASK = "command.copyfromcontainer.job.task";
    private static final String COPY_FROM_CONTAINER_JOB_TITLE = "command.copyfromcontainer.job.title";
    private static final String COPY_FROM_CONTAINER_JOB_SUBTASK = "command.copyfromcontainer.job.subtask";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        if (connection == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getString(MISSING_CONNECTION), (String)CommandMessages.getString(ERROR_COPYING_FROM_CONTAINER_NO_CONNECTION));
        } else {
            ContainerCopyFrom wizard = new ContainerCopyFrom(connection, container);
            boolean copyFromContainer = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (copyFromContainer) {
                this.performCopyFromContainer(connection, container, wizard.getTarget(), wizard.getSources());
            }
        }
        return null;
    }

    private void performCopyFromContainer(final IDockerConnection connection, final IDockerContainer container, final String target, final List<ContainerFileProxy> files) {
        Job copyFromContainerJob = new Job(CommandMessages.getFormattedString(COPY_FROM_CONTAINER_JOB_TITLE, container.name())){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 32[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ void lambda$0(ContainerFileProxy containerFileProxy, IDockerContainer iDockerContainer, DockerException dockerException) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getFormattedString(CopyFromContainerCommandHandler.ERROR_COPYING_FROM_CONTAINER, containerFileProxy.getLink(), iDockerContainer.name()), (String)(dockerException.getCause() != null ? dockerException.getCause().getMessage() : dockerException.getMessage()));
            }
        };
        copyFromContainerJob.schedule();
    }

    private class BlockingInputStream
    extends InputStream {
        private InputStream in;

        public BlockingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }
    }
}

