/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.QMLAnalyzer;
import org.eclipse.cdt.internal.qt.core.location.Position;
import org.eclipse.cdt.internal.qt.core.location.SourceLocation;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.cdt.qt.core.location.ISourceLocation;
import org.eclipse.cdt.qt.core.qmljs.IJSLiteral;
import org.eclipse.cdt.qt.core.qmljs.IJSRegExpLiteral;
import org.eclipse.cdt.qt.core.qmljs.IQmlASTNode;

public class QmlASTNodeHandler
implements InvocationHandler {
    private static final String NODE_QML_PREFIX = "QML";
    private static final String NODE_TYPE_PROPERTY = "type";
    private static final String NODE_REGEX_PROPERTY = "regex";
    private static final String CREATE_ENUM_METHOD = "fromObject";
    private static final String AST_PACKAGE = "org.eclipse.cdt.qt.core.qmljs.";
    private static final String AST_QML_PREFIX = "IQml";
    private static final String AST_JS_PREFIX = "IJS";
    private final QMLAnalyzer analyzer = (QMLAnalyzer)Activator.getService(IQMLAnalyzer.class);
    private final Bindings node;
    private final Map<String, Object> methodResults;

    private static String getPropertyName(String method) {
        String name = "";
        if (method.startsWith("is")) {
            name = String.valueOf(method.substring(2, 3).toLowerCase()) + method.substring(3);
        } else if (method.startsWith("get")) {
            name = String.valueOf(method.substring(3, 4).toLowerCase()) + method.substring(4);
        }
        if (name.equalsIgnoreCase("identifier")) {
            return "id";
        }
        if (name.equalsIgnoreCase("location")) {
            return "loc";
        }
        return name;
    }

    public static IQmlASTNode createQmlASTProxy(Bindings node) throws ClassNotFoundException {
        return QmlASTNodeHandler.createQmlASTProxy(node, null);
    }

    public static IQmlASTNode createQmlASTProxy(Bindings node, Class<?> returnType) throws ClassNotFoundException {
        String type = node.getOrDefault(NODE_TYPE_PROPERTY, "");
        type = type.startsWith(NODE_QML_PREFIX) ? AST_QML_PREFIX + type.substring(3) : AST_JS_PREFIX + type;
        Class<Object> astClass = Class.forName(AST_PACKAGE + type);
        if (astClass.equals(IJSLiteral.class) && node.get(NODE_REGEX_PROPERTY) != null) {
            astClass = IJSRegExpLiteral.class;
        }
        if (returnType != null) {
            if (!IQmlASTNode.class.isAssignableFrom(astClass)) {
                throw new ClassCastException(astClass + " cannot be cast to " + IQmlASTNode.class);
            }
            if (astClass.isAssignableFrom(returnType)) {
                astClass = returnType;
            }
        }
        return (IQmlASTNode)Proxy.newProxyInstance(QmlASTNodeHandler.class.getClassLoader(), new Class[]{astClass}, (InvocationHandler)new QmlASTNodeHandler(node));
    }

    private QmlASTNodeHandler(Bindings node) {
        this.node = node;
        this.methodResults = new HashMap<String, Object>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mName = method.getName();
        if (!this.methodResults.containsKey(method.getName())) {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                this.methodResults.put(mName, ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args));
            } else {
                String pName = QmlASTNodeHandler.getPropertyName(mName);
                this.methodResults.put(mName, this.handleObject(this.node.get(pName), method.getReturnType()));
            }
        }
        return this.methodResults.get(mName);
    }

    private Object handleObject(Object value, Class<?> expectedType) throws Throwable {
        if (expectedType.isArray()) {
            Object arr = Array.newInstance(expectedType.getComponentType(), ((Bindings)value).size());
            int ctr = 0;
            for (Object obj : ((Bindings)value).values()) {
                Array.set(arr, ctr++, this.handleObject(obj, expectedType.getComponentType()));
            }
            return arr;
        }
        if (expectedType.equals(Object.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(ISourceLocation.class)) {
            if (value instanceof Bindings) {
                Bindings bind = (Bindings)value;
                SourceLocation loc = new SourceLocation();
                loc.setSource((String)bind.get("source"));
                Bindings start = (Bindings)bind.get("start");
                loc.setStart(new Position(((Number)start.get("line")).intValue(), ((Number)start.get("column")).intValue()));
                Bindings end = (Bindings)bind.get("end");
                loc.setEnd(new Position(((Number)end.get("line")).intValue(), ((Number)end.get("column")).intValue()));
                return loc;
            }
            return new SourceLocation();
        }
        if (expectedType.isAssignableFrom(List.class)) {
            if (value instanceof Bindings) {
                ArrayList<IQmlASTNode> list = new ArrayList<IQmlASTNode>();
                Bindings[] bindingsArray = (Bindings[])this.analyzer.toJavaArray((Bindings)value, Bindings[].class);
                int n = bindingsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bindings object = bindingsArray[n2];
                    list.add(QmlASTNodeHandler.createQmlASTProxy(object));
                    ++n2;
                }
                return list;
            }
            return null;
        }
        if (expectedType.isPrimitive()) {
            return this.handlePrimitive(value, expectedType);
        }
        if (expectedType.isAssignableFrom(Number.class)) {
            if (value instanceof Number) {
                return value;
            }
            return 0;
        }
        if (expectedType.isEnum()) {
            return expectedType.getMethod(CREATE_ENUM_METHOD, Object.class).invoke(null, value);
        }
        if (value instanceof Bindings) {
            return QmlASTNodeHandler.createQmlASTProxy((Bindings)value, expectedType);
        }
        return value;
    }

    private Object handlePrimitive(Object value, Class<?> expectedType) throws Throwable {
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                if (value instanceof Boolean) {
                    return value;
                }
                return false;
            }
            if (expectedType.equals(Character.TYPE)) {
                if (value instanceof Character) {
                    return value;
                }
                return Character.valueOf('\u0000');
            }
            if (expectedType.equals(Byte.TYPE)) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)0;
            }
            if (expectedType.equals(Short.TYPE)) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)0;
            }
            if (expectedType.equals(Integer.TYPE)) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return 0;
            }
            if (expectedType.equals(Long.TYPE)) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                return 0L;
            }
            if (expectedType.equals(Float.TYPE)) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                return Float.valueOf(0.0f);
            }
            if (expectedType.equals(Double.TYPE)) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return 0.0;
            }
        }
        throw new IllegalArgumentException("expectedType was not a primitive type");
    }
}

