/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.osgi.framework.Bundle;

public class TmfAnalysisModuleHelperConfigElement
implements IAnalysisModuleHelper {
    private static final @NonNull Comparator<@NonNull ApplicableClass> APPLICABLE_CLASS_COMPARATOR = new Comparator<ApplicableClass>(){

        @Override
        public int compare(@NonNull ApplicableClass o1, @NonNull ApplicableClass o2) {
            if (o1.fClass.equals(o2.fClass)) {
                return 0;
            }
            if (o1.fClass.isAssignableFrom(o2.fClass)) {
                return -1;
            }
            if (o2.fClass.isAssignableFrom(o1.fClass)) {
                return 1;
            }
            return 0;
        }
    };
    private final IConfigurationElement fCe;
    private @Nullable List<ApplicableClass> fApplicableClasses = null;

    public TmfAnalysisModuleHelperConfigElement(IConfigurationElement ce) {
        this.fCe = ce;
    }

    @Override
    public String getId() {
        String id = this.fCe.getAttribute("id");
        if (id == null) {
            throw new IllegalStateException();
        }
        return id;
    }

    @Override
    public String getName() {
        String name = this.fCe.getAttribute("name");
        if (name == null) {
            throw new IllegalStateException();
        }
        return name;
    }

    @Override
    public boolean isAutomatic() {
        return Boolean.parseBoolean(this.fCe.getAttribute("automatic"));
    }

    @Override
    public boolean appliesToExperiment() {
        return Boolean.parseBoolean(this.fCe.getAttribute("applies_experiment"));
    }

    @Override
    public String getHelpText() {
        return "The trace must be opened to get the help message";
    }

    @Override
    public String getIcon() {
        return this.fCe.getAttribute("icon");
    }

    @Override
    public Bundle getBundle() {
        return TmfAnalysisModuleHelperConfigElement.getBundle(this.fCe);
    }

    private static Bundle getBundle(IConfigurationElement element) {
        return ContributorFactoryOSGi.resolve((IContributor)element.getContributor());
    }

    private List<ApplicableClass> fillApplicableClasses() {
        ArrayList<IConfigurationElement> ces = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] tracetypeCE = this.fCe.getChildren("tracetype");
        ces.addAll(Arrays.asList(tracetypeCE));
        tracetypeCE = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.analysis");
        String id = this.getId();
        IConfigurationElement[] iConfigurationElementArray = tracetypeCE;
        int n = tracetypeCE.length;
        int n2 = 0;
        while (n2 < n) {
            String analysisId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getName();
            if (elementName.equals("tracetype") && id.equals(analysisId = element.getAttribute("id"))) {
                ces.add(element);
            }
            ++n2;
        }
        HashMap classMap = new HashMap();
        ces.forEach(ce -> {
            ApplicableClass traceTypeApplies = TmfAnalysisModuleHelperConfigElement.parseTraceTypeElement(ce);
            if (traceTypeApplies != null) {
                classMap.put(traceTypeApplies.fClass, traceTypeApplies);
            }
        });
        ArrayList<ApplicableClass> applicableClasses = new ArrayList<ApplicableClass>(classMap.values());
        return TmfAnalysisModuleHelperConfigElement.sortApplicableClasses(applicableClasses);
    }

    private static List<ApplicableClass> sortApplicableClasses(List<ApplicableClass> applicableClasses) {
        if (applicableClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ApplicableClass> sorted = new ArrayList<ApplicableClass>(applicableClasses.size());
        sorted.add(applicableClasses.get(0));
        int i = 1;
        while (i < applicableClasses.size()) {
            int pos = i;
            ApplicableClass current = applicableClasses.get(i);
            int j = 0;
            while (j < sorted.size()) {
                int cmp = APPLICABLE_CLASS_COMPARATOR.compare(Objects.requireNonNull(current), Objects.requireNonNull((ApplicableClass)sorted.get(j)));
                if (cmp < 0) {
                    pos = j;
                } else if (cmp > 0) {
                    pos = j + 1;
                }
                ++j;
            }
            sorted.add(pos, current);
            ++i;
        }
        return sorted;
    }

    private static ApplicableClass parseTraceTypeElement(IConfigurationElement element) {
        try {
            Class applyclass = TmfAnalysisModuleHelperConfigElement.getBundle(element).loadClass(element.getAttribute("class"));
            String classAppliesVal = element.getAttribute("applies");
            boolean classApplies = true;
            if (classAppliesVal != null) {
                classApplies = Boolean.parseBoolean(classAppliesVal);
            }
            if (classApplies) {
                return new ApplicableClass(applyclass, true);
            }
            return new ApplicableClass(applyclass, false);
        }
        catch (ClassNotFoundException | InvalidRegistryObjectException e) {
            Activator.logError("Error in applies to trace", e);
            return null;
        }
    }

    private List<ApplicableClass> getApplicableClasses() {
        List<ApplicableClass> applicableClasses = this.fApplicableClasses;
        if (applicableClasses == null) {
            this.fApplicableClasses = applicableClasses = this.fillApplicableClasses();
        }
        return applicableClasses;
    }

    private @Nullable Boolean appliesToTraceClass(Class<? extends ITmfTrace> traceclass) {
        Boolean applies = null;
        for (ApplicableClass clazz : this.getApplicableClasses()) {
            if (clazz.fApplies) {
                if (!clazz.fClass.isAssignableFrom(traceclass)) continue;
                applies = true;
                continue;
            }
            if (!clazz.fClass.isAssignableFrom(traceclass)) continue;
            applies = false;
        }
        return applies;
    }

    @Override
    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceclass) {
        Boolean applies = this.appliesToTraceClass(traceclass);
        if (applies == null && TmfExperiment.class.isAssignableFrom(traceclass)) {
            return this.appliesToExperiment();
        }
        return applies == null ? false : applies;
    }

    @Override
    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        HashSet<Class<? extends ITmfTrace>> traceTypes = new HashSet<Class<? extends ITmfTrace>>();
        for (TraceTypeHelper tth : TmfTraceType.getTraceTypeHelpers()) {
            if (!this.appliesToTraceType(tth.getTraceClass())) continue;
            traceTypes.add(tth.getTraceClass());
        }
        return traceTypes;
    }

    @Override
    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            Iterable<@NonNull TmfAbstractAnalysisRequirement> requirements = module.getAnalysisRequirements();
            module.dispose();
            return requirements;
        }
        return Collections.emptySet();
    }

    private IAnalysisModule createModule() {
        IAnalysisModule module = null;
        try {
            module = (IAnalysisModule)this.fCe.createExecutableExtension("analysis_module");
            module.setName(this.getName());
            module.setId(this.getId());
        }
        catch (CoreException e) {
            Activator.logError("Error getting analysis modules from configuration files", e);
        }
        return module;
    }

    @Override
    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        IConfigurationElement[] parametersCE;
        Boolean applies = this.appliesToTraceClass(trace.getClass());
        if (applies == null && trace instanceof TmfExperiment && this.appliesToExperiment()) {
            for (ITmfTrace expTrace : TmfTraceManager.getTraceSet(trace)) {
                if (this.appliesToTraceClass(expTrace.getClass()) != Boolean.TRUE) continue;
                applies = true;
                break;
            }
        }
        if (applies != Boolean.TRUE) {
            return null;
        }
        IAnalysisModule module = this.createModule();
        if (module == null) {
            return null;
        }
        module.setAutomatic(this.isAutomatic());
        IConfigurationElement[] iConfigurationElementArray = parametersCE = this.fCe.getChildren("parameter");
        int n = parametersCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String paramName = element.getAttribute("name");
            if (paramName != null) {
                module.addParameter(paramName);
                String defaultValue = element.getAttribute("default_value");
                if (defaultValue != null) {
                    module.setParameter(paramName, defaultValue);
                }
            }
            ++n2;
        }
        if (module.setTrace(trace)) {
            TmfAnalysisManager.analysisModuleCreated(module);
        } else {
            module.dispose();
            module = null;
        }
        return module;
    }

    @Override
    public String getHelpText(@NonNull ITmfTrace trace) {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            String ret = module.getHelpText(trace);
            module.dispose();
            return ret;
        }
        return this.getHelpText();
    }

    private static class ApplicableClass {
        private final Class<?> fClass;
        private final boolean fApplies;

        public ApplicableClass(Class<?> clazz, boolean applies) {
            this.fClass = clazz;
            this.fApplies = applies;
        }
    }
}

