/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.oomph.extractor.lib.JREData;
import org.eclipse.oomph.extractor.lib.JREValidator;
import org.eclipse.oomph.internal.jreinfo.JREInfoPlugin;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREInfo;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.osgi.framework.Bundle;

final class InfoManager {
    public static final InfoManager INSTANCE = new InfoManager();
    private static final String LIB_CLASS_PATH;
    private final Map<File, JRE> infos = new HashMap<File, JRE>();

    static {
        StringBuilder builder = new StringBuilder();
        try {
            List classPath;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.oomph.extractor.lib");
            if (bundle != null && (classPath = OomphPlugin.getClassPath((Bundle)bundle)) != null) {
                for (File file : classPath) {
                    if (builder.length() != 0) {
                        builder.append(File.pathSeparatorChar);
                    }
                    builder.append(file.getAbsolutePath());
                }
            }
        }
        catch (Throwable throwable) {}
        LIB_CLASS_PATH = builder.toString();
    }

    private InfoManager() {
        this.loadInfos();
    }

    public synchronized void refresh() {
        this.loadInfos();
    }

    public synchronized JRE getInfo(File canonicalJavaHome) {
        JRE jre = this.infos.get(canonicalJavaHome);
        if (jre == null) {
            try {
                JREData result;
                if (canonicalJavaHome.isDirectory() && (result = InfoManager.testJRE(canonicalJavaHome)) != null) {
                    int major = result.getMajor();
                    int minor = result.getMinor();
                    int micro = result.getMicro();
                    int bitness = result.getBitness();
                    boolean jdk = JREInfo.isJDK(canonicalJavaHome) == 1;
                    File executable = JRE.getExecutable(canonicalJavaHome);
                    long lastModified = executable.lastModified();
                    jre = new JRE(canonicalJavaHome, major, minor, micro, bitness, jdk, lastModified);
                    this.infos.put(canonicalJavaHome, jre);
                    try {
                        ArrayList<String> lines = new ArrayList<String>();
                        for (JRE info : this.infos.values()) {
                            lines.add(info.toLine());
                        }
                        IOUtil.writeLines((File)InfoManager.getCacheFile(), (String)"UTF-8", lines);
                    }
                    catch (Exception ex) {
                        JREInfoPlugin.INSTANCE.log(ex);
                    }
                }
            }
            catch (Exception ex) {
                JREInfoPlugin.INSTANCE.log(ex);
            }
        }
        return jre;
    }

    private void loadInfos() {
        this.infos.clear();
        File cacheFile = InfoManager.getCacheFile();
        if (cacheFile.isFile()) {
            try {
                for (String line : IOUtil.readLines((File)cacheFile, (String)"UTF-8")) {
                    try {
                        JRE jre = new JRE(line);
                        if (!jre.isValid()) continue;
                        this.infos.put(jre.getJavaHome(), jre);
                    }
                    catch (RuntimeException ex) {
                        JREInfoPlugin.INSTANCE.log((IStatus)new Status(2, JREInfoPlugin.INSTANCE.getSymbolicName(), "The cache file '" + cacheFile + "' contains an invalid JRE entry: '" + line + "'", (Throwable)ex));
                    }
                }
            }
            catch (Exception ex) {
                JREInfoPlugin.INSTANCE.log(ex);
            }
        }
    }

    private static File getCacheFile() {
        return new File(JREInfoPlugin.INSTANCE.getUserLocation().append("infos.txt").toOSString());
    }

    private static JREData testJRE(File javaHome) {
        String executable = JRE.getExecutable(javaHome).getAbsolutePath();
        return InfoManager.testJRE(executable);
    }

    static JREData testJRE(String executable) {
        Process process = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(executable, "-cp", LIB_CLASS_PATH, JREValidator.class.getName());
            process = builder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedReader.readLine();
            if (line != null) {
                JREData jREData = new JREData(line);
                return jREData;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (process != null) {
                IOUtil.closeSilent((Closeable)process.getInputStream());
                IOUtil.closeSilent((Closeable)process.getOutputStream());
                IOUtil.closeSilent((Closeable)process.getErrorStream());
            }
        }
        return null;
    }
}

