/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.gis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.crs.ProjectedCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;
import org.cts.registry.RegistryManager;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisTransformRequest;
import org.jkiss.dbeaver.model.gis.SpatialDataProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class GisTransformUtils {
    private static final Log log = Log.getLog(GisTransformUtils.class);
    private static CRSFactory crsFactory = new CRSFactory();
    private static CoordinateReferenceSystem crs3857;
    private static List<Integer> crsCodes;

    static {
        RegistryManager registryManager = crsFactory.getRegistryManager();
        registryManager.addRegistry((Registry)new EPSGRegistry());
        try {
            crs3857 = crsFactory.getCRS("EPSG:3857");
        }
        catch (CRSException e) {
            log.error((Object)"Error getting default CRS", (Throwable)e);
        }
    }

    public static CRSFactory getCRSFactory() {
        return crsFactory;
    }

    public static synchronized List<Integer> getSortedEPSGCodes() {
        if (crsCodes == null) {
            crsCodes = new ArrayList<Integer>();
            try {
                for (String code : crsFactory.getSupportedCodes("EPSG")) {
                    crsCodes.add(CommonUtils.toInt((Object)code));
                }
                crsCodes.sort(Integer::compareTo);
            }
            catch (RegistryException e) {
                log.debug((Object)e);
            }
        }
        return crsCodes;
    }

    public static void transformGisData(GisTransformRequest request) throws DBException {
        try {
            CoordinateReferenceSystem crs1 = crsFactory.getCRS("EPSG:" + request.getSourceSRID());
            CoordinateReferenceSystem crs2 = crsFactory.getCRS("EPSG:" + request.getTargetSRID());
            try {
                Geometry targetValue = GisTransformUtils.transformGisData(request.getSourceValue(), crs1, crs2);
                targetValue.setSRID(request.getTargetSRID());
                request.setTargetValue(targetValue);
                request.setShowOnMap(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (CommonUtils.equalObjects((Object)crs1.getCoordinateSystem(), (Object)crs3857.getCoordinateSystem())) {
                    Geometry geometry = GisTransformUtils.transformGisData(request.getSourceValue(), crs3857, crs2);
                    geometry.setSRID(request.getTargetSRID());
                    request.setTargetValue(geometry);
                    request.setShowOnMap(false);
                }
            }
        }
        catch (Exception e) {
            throw new DBException("Error transforming SRIDs", (Throwable)e);
        }
    }

    private static Geometry transformGeometryTo(ProjectedCRS projectedCRS, Geometry geometry) throws CoordinateOperationException, IllegalCoordinateException {
        CoordinateOperation coordinateOperation = projectedCRS.toGeographicCoordinateConverter();
        Coordinate[] coordinateArray = geometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            double[] srcCoord = GisTransformUtils.getCoordinateValues(coord);
            double[] transform = coordinateOperation.transform(srcCoord);
            GisTransformUtils.setCoordinateValues(coord, transform);
            ++n2;
        }
        return null;
    }

    public static Geometry transformGisData(Geometry jtsValue, CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) throws Exception {
        Set coordOps;
        if (crs1 instanceof GeodeticCRS && crs2 instanceof GeodeticCRS && !(coordOps = CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)crs1), (GeodeticCRS)((GeodeticCRS)crs2))).isEmpty()) {
            for (CoordinateOperation op : coordOps) {
                jtsValue = GisTransformUtils.transformGeometry(jtsValue, op);
            }
            return jtsValue;
        }
        return jtsValue;
    }

    private static Geometry transformGeometry(Geometry geom, CoordinateOperation op) throws Exception {
        geom = (Geometry)geom.clone();
        Coordinate[] coordinateArray = geom.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            double[] srcCoord = GisTransformUtils.getCoordinateValues(coord);
            double[] targetCoord = op.transform(srcCoord);
            GisTransformUtils.setCoordinateValues(coord, targetCoord);
            ++n2;
        }
        return geom;
    }

    private static void setCoordinateValues(Coordinate coord, double[] targetCoord) {
        if (targetCoord != null) {
            coord.x = targetCoord[0];
            coord.y = targetCoord[1];
            if (targetCoord.length > 2) {
                coord.z = targetCoord[2];
            }
        }
    }

    private static double[] getCoordinateValues(Coordinate coord) {
        double[] srcCoord = Double.isNaN(coord.z) ? new double[]{coord.x, coord.y} : new double[]{coord.x, coord.y, coord.z};
        return srcCoord;
    }

    public static DBGeometry getGeometryValueFromObject(DBSDataContainer dataContainer, DBDValueHandler valueHandler, DBSTypedObject valueType, Object cellValue) {
        block13: {
            if (cellValue instanceof DBGeometry) {
                return (DBGeometry)cellValue;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (DBCSession utilSession = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)dataContainer, (String)"Convert GIS value");){
                    Object convertedValue = valueHandler.getValueFromObject(utilSession, valueType, cellValue, false);
                    if (!(convertedValue instanceof DBGeometry)) break block13;
                    return (DBGeometry)convertedValue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                log.debug((Object)"Error trandforming geometry value", (Throwable)e);
            }
        }
        return null;
    }

    public static SpatialDataProvider getSpatialDataProvider(DBPDataSource dataSource) {
        if (dataSource instanceof IAdaptable) {
            return (SpatialDataProvider)((IAdaptable)dataSource).getAdapter(SpatialDataProvider.class);
        }
        return null;
    }
}

