/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreContentJSON;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreJSONValueHandler
extends JDBCContentValueHandler {
    public static final PostgreJSONValueHandler INSTANCE = new PostgreJSONValueHandler();

    protected DBDContent fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        String json = resultSet.getString(index);
        return new PostgreContentJSON(session.getDataSource(), json);
    }

    public DBDContent getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (PostgreUtils.isPGObject(object)) {
            object = PostgreUtils.extractPGObjectValue(object);
        }
        if (object == null) {
            return new PostgreContentJSON(session.getDataSource(), null);
        }
        if (object instanceof PostgreContentJSON) {
            return copy ? ((PostgreContentJSON)((Object)object)).cloneValue(session.getProgressMonitor()) : (PostgreContentJSON)((Object)object);
        }
        if (object instanceof String) {
            return new PostgreContentJSON(session.getDataSource(), (String)object);
        }
        return super.getValueFromObject(session, type, object, copy);
    }
}

