Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var ErrorView = (function () {
  function ErrorView(packageManager, _ref) {
    var _this = this;

    var message = _ref.message;
    var stderr = _ref.stderr;
    var packageInstallError = _ref.packageInstallError;

    _classCallCheck(this, ErrorView);

    _etch2['default'].initialize(this);

    this.isOutputHidden = true;
    this.refs.detailsArea.style.display = 'none';
    this.refs.details.textContent = stderr;
    this.refs.message.textContent = message;

    // Check for native build tools and show warning if missing.
    if (packageInstallError && process.platform === 'win32') {
      packageManager.checkNativeBuildTools()['catch'](function () {
        _this.refs.alert.appendChild(new CompileToolsErrorView().element);
      });
    }
  }

  _createClass(ErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'error-message' },
        _etch2['default'].dom(
          'div',
          { ref: 'alert', className: 'alert alert-danger alert-dismissable native-key-bindings', tabIndex: '-1' },
          _etch2['default'].dom('button', { ref: 'close', className: 'close icon icon-x', onclick: function () {
              return _this2.destroy();
            } }),
          _etch2['default'].dom('span', { ref: 'message', className: 'native-key-bindings' }),
          _etch2['default'].dom(
            'a',
            { ref: 'detailsLink', className: 'alert-link error-link', onclick: function () {
                return _this2.toggleOutput();
              } },
            'Show output…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'detailsArea', className: 'padded' },
            _etch2['default'].dom('pre', { ref: 'details', className: 'error-details text' })
          )
        )
      );
    }
  }, {
    key: 'toggleOutput',
    value: function toggleOutput() {
      if (this.isOutputHidden) {
        this.isOutputHidden = false;
        this.refs.detailsArea.style.display = '';
        this.refs.detailsLink.textContent = 'Hide output…';
      } else {
        this.isOutputHidden = true;
        this.refs.detailsArea.style.display = 'none';
        this.refs.detailsLink.textContent = 'Show output…';
      }
    }
  }]);

  return ErrorView;
})();

exports['default'] = ErrorView;

var CompileToolsErrorView = (function () {
  function CompileToolsErrorView() {
    _classCallCheck(this, CompileToolsErrorView);

    _etch2['default'].initialize(this);
  }

  _createClass(CompileToolsErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        null,
        _etch2['default'].dom(
          'div',
          { className: 'icon icon-alert compile-tools-heading compile-tools-message' },
          'Compiler tools not found'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          'Packages that depend on modules that contain C/C++ code will fail to install.'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Read '
          ),
          _etch2['default'].dom(
            'a',
            { className: 'link', href: 'https://github.com/atom/atom/blob/master/docs/build-instructions/windows.md' },
            'here'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' for instructions on installing Python and Visual Studio.'
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Run '
          ),
          _etch2['default'].dom(
            'code',
            { className: 'alert-danger' },
            'apm install --check'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' after installing to test compiling a native module.'
          )
        )
      );
    }
  }]);

  return CompileToolsErrorView;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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