"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _keytarStrategy = require("../shared/keytar-strategy");

var _remoteController = _interopRequireDefault(require("../controllers/remote-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return loginModel.getToken(this.props.endpoint.getLoginAccount());
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithToken(token) {
    if (token === null) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    if (token === _keytarStrategy.UNAUTHENTICATED) {
      return _react["default"].createElement(_githubLoginView["default"], {
        onLogin: this.handleLogin
      });
    }

    if (token === _keytarStrategy.INSUFFICIENT) {
      return _react["default"].createElement(_githubLoginView["default"], {
        onLogin: this.handleLogin
      }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
    }

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/remoteContainerQuery.graphql");

      if (node.hash && node.hash !== "b83aa6c27c5d7e1c499badf2e6bfab6b") {
        console.error("The definition of 'remoteContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/remoteContainerQuery.graphql");
    });

    const variables = {
      owner: this.props.remote.getOwner(),
      name: this.props.remote.getRepo()
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: result => this.renderWithResult(result, token)
    });
  }

  renderWithResult({
    error,
    props,
    retry
  }, token) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_remoteController["default"], {
      endpoint: this.props.endpoint,
      token: token,
      repository: props.repository,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onPushBranch: this.props.onPushBranch
    });
  }

  handleLogin(token) {
    (0, _reporterProxy.incrementCounter)('github-login');
    this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
  }

  handleLogout() {
    (0, _reporterProxy.incrementCounter)('github-logout');
    this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
  }

}

exports["default"] = RemoteContainer;

_defineProperty(RemoteContainer, "propTypes", {
  // Connection
  loginModel: _propTypes["default"].object.isRequired,
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Repository attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workingDirectory: _propTypes["default"].string,
  workspace: _propTypes["default"].object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  // Action methods
  onPushBranch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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