"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishTooltipContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class BareIssueishTooltipContainer extends _react["default"].Component {
  render() {
    const resource = this.props.resource;
    const author = resource.author || _helpers.GHOST_USER;
    const {
      repository,
      state,
      number,
      title,
      __typename
    } = resource;
    const icons = typeAndStateToIcon[__typename] || {};
    const icon = icons[state] || '';
    return _react["default"].createElement("div", {
      className: "github-IssueishTooltip"
    }, _react["default"].createElement("div", {
      className: "issueish-avatar-and-title"
    }, _react["default"].createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }), _react["default"].createElement("h3", {
      className: "issueish-title"
    }, title)), _react["default"].createElement("div", {
      className: "issueish-badge-and-link"
    }, _react["default"].createElement("span", {
      className: (0, _classnames["default"])('issueish-badge', 'badge', state.toLowerCase())
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon
    }), state.toLowerCase()), _react["default"].createElement("span", {
      className: "issueish-link"
    }, repository.owner.login, "/", repository.name, "#", number)));
  }

}

exports.BareIssueishTooltipContainer = BareIssueishTooltipContainer;

_defineProperty(BareIssueishTooltipContainer, "propTypes", {
  resource: _propTypes["default"].shape({
    issue: _propTypes["default"].shape({}),
    pullRequest: _propTypes["default"].shape({})
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishTooltipContainer, {
  resource: function () {
    const node = require("./__generated__/issueishTooltipContainer_resource.graphql");

    if (node.hash && node.hash !== "8980fc73c7ed3f632f0612ce14f2f0d1") {
      console.error("The definition of 'issueishTooltipContainer_resource' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishTooltipContainer_resource.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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