(function() {
  var BufferSearch, CompositeDisposable, Disposable, FindOptions, FindView, History, HistoryCycler, ProjectFindView, ResultsModel, ResultsPaneView, SelectNext, TextBuffer, getIconServices, ref, ref1;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, TextBuffer = ref.TextBuffer;

  SelectNext = require('./select-next');

  ref1 = require('./history'), History = ref1.History, HistoryCycler = ref1.HistoryCycler;

  FindOptions = require('./find-options');

  BufferSearch = require('./buffer-search');

  getIconServices = require('./get-icon-services');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  module.exports = {
    activate: function(arg) {
      var findHistory, findOptions, handleEditorCancel, pathsHistory, ref2, replaceHistory, selectNextObjectForEditorElement, showPanel, togglePanel;
      ref2 = arg != null ? arg : {}, findOptions = ref2.findOptions, findHistory = ref2.findHistory, replaceHistory = ref2.replaceHistory, pathsHistory = ref2.pathsHistory;
      if (atom.config.get('find-and-replace.openProjectFindResultsInRightPane')) {
        atom.config.set('find-and-replace.projectSearchResultsPaneSplitDirection', 'right');
      }
      atom.config.unset('find-and-replace.openProjectFindResultsInRightPane');
      atom.workspace.addOpener(function(filePath) {
        if (filePath === ResultsPaneView.URI) {
          return new ResultsPaneView();
        }
      });
      this.subscriptions = new CompositeDisposable;
      this.currentItemSub = new Disposable;
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.findOptions = new FindOptions(findOptions);
      this.findModel = new BufferSearch(this.findOptions);
      this.resultsModel = new ResultsModel(this.findOptions);
      this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((function(_this) {
        return function(paneItem) {
          _this.subscriptions["delete"](_this.currentItemSub);
          _this.currentItemSub.dispose();
          if (atom.workspace.isTextEditor(paneItem)) {
            return _this.findModel.setEditor(paneItem);
          } else if ((paneItem != null ? paneItem.observeEmbeddedTextEditor : void 0) != null) {
            _this.currentItemSub = paneItem.observeEmbeddedTextEditor(function(editor) {
              if (atom.workspace.getCenter().getActivePaneItem() === paneItem) {
                return _this.findModel.setEditor(editor);
              }
            });
            return _this.subscriptions.add(_this.currentItemSub);
          } else if ((paneItem != null ? paneItem.getEmbeddedTextEditor : void 0) != null) {
            return _this.findModel.setEditor(paneItem.getEmbeddedTextEditor());
          } else {
            return _this.findModel.setEditor(null);
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('.find-and-replace, .project-find', 'window:focus-next-pane', function() {
        return atom.views.getView(atom.workspace).focus();
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(arg1) {
          var target;
          target = arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          _this.projectFindView.focusFindElement();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-replace-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusReplaceEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:clear-history', (function(_this) {
        return function() {
          _this.findHistory.clear();
          return _this.replaceHistory.clear();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(arg1) {
          var isMiniEditor, ref3, ref4, target;
          target = arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((ref3 = _this.findPanel) != null) {
              ref3.hide();
            }
            return (ref4 = _this.projectFindPanel) != null ? ref4.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      showPanel = function(panelToShow, panelToHide, postShowAction) {
        panelToHide.hide();
        panelToShow.show();
        return typeof postShowAction === "function" ? postShowAction() : void 0;
      };
      togglePanel = function(panelToToggle, panelToHide, postToggleAction) {
        panelToHide.hide();
        if (panelToToggle.isVisible()) {
          return panelToToggle.hide();
        } else {
          panelToToggle.show();
          return typeof postToggleAction === "function" ? postToggleAction() : void 0;
        }
      };
      return this.subscriptions.add(atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      }));
    },
    consumeElementIcons: function(service) {
      getIconServices().setElementIcons(service);
      return new Disposable(function() {
        return getIconServices().resetElementIcons();
      });
    },
    consumeFileIcons: function(service) {
      getIconServices().setFileIcons(service);
      return new Disposable(function() {
        return getIconServices().resetFileIcons();
      });
    },
    toggleAutocompletions: function(value) {
      var disposable, ref2;
      if (this.findView == null) {
        return;
      }
      if (value) {
        this.autocompleteSubscriptions = new CompositeDisposable;
        disposable = typeof this.autocompleteWatchEditor === "function" ? this.autocompleteWatchEditor(this.findView.findEditor, ['default']) : void 0;
        if (disposable != null) {
          return this.autocompleteSubscriptions.add(disposable);
        }
      } else {
        return (ref2 = this.autocompleteSubscriptions) != null ? ref2.dispose() : void 0;
      }
    },
    consumeAutocompleteWatchEditor: function(watchEditor) {
      this.autocompleteWatchEditor = watchEditor;
      atom.config.observe('find-and-replace.autocompleteSearches', (function(_this) {
        return function(value) {
          return _this.toggleAutocompletions(value);
        };
      })(this));
      return new Disposable((function(_this) {
        return function() {
          var ref2;
          if ((ref2 = _this.autocompleteSubscriptions) != null) {
            ref2.dispose();
          }
          return _this.autocompleteWatchEditor = null;
        };
      })(this));
    },
    provideService: function() {
      return {
        resultsMarkerLayerForTextEditor: this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)
      };
    },
    createViews: function() {
      var findBuffer, findHistoryCycler, options, pathsBuffer, pathsHistoryCycler, replaceBuffer, replaceHistoryCycler;
      if (this.findView != null) {
        return;
      }
      findBuffer = new TextBuffer;
      replaceBuffer = new TextBuffer;
      pathsBuffer = new TextBuffer;
      findHistoryCycler = new HistoryCycler(findBuffer, this.findHistory);
      replaceHistoryCycler = new HistoryCycler(replaceBuffer, this.replaceHistory);
      pathsHistoryCycler = new HistoryCycler(pathsBuffer, this.pathsHistory);
      options = {
        findBuffer: findBuffer,
        replaceBuffer: replaceBuffer,
        pathsBuffer: pathsBuffer,
        findHistoryCycler: findHistoryCycler,
        replaceHistoryCycler: replaceHistoryCycler,
        pathsHistoryCycler: pathsHistoryCycler
      };
      this.findView = new FindView(this.findModel, options);
      this.projectFindView = new ProjectFindView(this.resultsModel, options);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      ResultsPaneView.model = this.resultsModel;
      return this.toggleAutocompletions(atom.config.get('find-and-replace.autocompleteSearches'));
    },
    deactivate: function() {
      var ref2, ref3, ref4, ref5, ref6, ref7, ref8;
      if ((ref2 = this.findPanel) != null) {
        ref2.destroy();
      }
      this.findPanel = null;
      if ((ref3 = this.findView) != null) {
        ref3.destroy();
      }
      this.findView = null;
      if ((ref4 = this.findModel) != null) {
        ref4.destroy();
      }
      this.findModel = null;
      if ((ref5 = this.projectFindPanel) != null) {
        ref5.destroy();
      }
      this.projectFindPanel = null;
      if ((ref6 = this.projectFindView) != null) {
        ref6.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      this.resultsModel = null;
      if ((ref7 = this.autocompleteSubscriptions) != null) {
        ref7.dispose();
      }
      this.autocompleteManagerService = null;
      if ((ref8 = this.subscriptions) != null) {
        ref8.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      return {
        findOptions: this.findOptions.serialize(),
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.pathsHistory.serialize()
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
