Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.resourcePath = this.normalizePath(params.resourcePath || process.resourcesPath);
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: '2',
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.scrubPath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || 'none',
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(pathToNormalize) {
      return pathToNormalize.replace('file:///', '') // Sometimes it's a uri
      .replace(/\\/g, '/'); // Unify path separators across Win/macOS/Linux
    }
  }, {
    key: 'scrubPath',
    value: function scrubPath(pathToScrub) {
      var absolutePath = this.normalizePath(pathToScrub);

      if (this.isBundledFile(absolutePath)) {
        return this.normalizePath(_path2['default'].relative(this.resourcePath, absolutePath));
      } else {
        return absolutePath.replace(this.normalizePath(_fsPlus2['default'].getHomeDirectory()), '~') // Remove users home dir
        .replace(/.*(\/packages\/.*)/, '$1'); // Remove everything before app.asar or packages
      }
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      var fileName = topFrame ? topFrame.getFileName() : null;
      return fileName && (this.isBundledFile(fileName) || this.isTeletypeFile(fileName));
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: 'Are you willing to submit this information to a private server for debugging purposes?',
        dismissable: true,
        buttons: [{
          text: 'No',
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: 'Yes, Submit for Debugging',
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      var availablePackagePaths = atom.packages.getPackageDirPaths();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (availablePackagePaths.includes(_path2['default'].dirname(pack.path))) {
            userPackages[pack.name] = pack.metadata.version;
          } else {
            bundledPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect the following information to resolve this error:', function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'error';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect some information to resolve an unexpected condition:', function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'warning';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }, {
    key: 'isBundledFile',
    value: function isBundledFile(fileName) {
      return this.normalizePath(fileName).indexOf(this.resourcePath) === 0;
    }
  }, {
    key: 'isTeletypeFile',
    value: function isTeletypeFile(fileName) {
      var teletypePath = atom.packages.resolvePackagePath('teletype');
      return teletypePath && this.normalizePath(fileName).indexOf(teletypePath) === 0;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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