/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import java.util.function.Function;

final class AutoValue_ArgumentChangeFinder
extends ArgumentChangeFinder {
    private final Function<ParameterPair, Double> distanceFunction;
    private final ImmutableList<Heuristic> heuristics;

    private AutoValue_ArgumentChangeFinder(Function<ParameterPair, Double> distanceFunction, ImmutableList<Heuristic> heuristics) {
        this.distanceFunction = distanceFunction;
        this.heuristics = heuristics;
    }

    @Override
    Function<ParameterPair, Double> distanceFunction() {
        return this.distanceFunction;
    }

    @Override
    ImmutableList<Heuristic> heuristics() {
        return this.heuristics;
    }

    public String toString() {
        return "ArgumentChangeFinder{distanceFunction=" + this.distanceFunction + ", heuristics=" + this.heuristics + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ArgumentChangeFinder) {
            ArgumentChangeFinder that = (ArgumentChangeFinder)o;
            return this.distanceFunction.equals(that.distanceFunction()) && this.heuristics.equals(that.heuristics());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.distanceFunction.hashCode();
        h *= 1000003;
        return h ^= this.heuristics.hashCode();
    }

    static final class Builder
    extends ArgumentChangeFinder.Builder {
        private Function<ParameterPair, Double> distanceFunction;
        private ImmutableList.Builder<Heuristic> heuristicsBuilder$;
        private ImmutableList<Heuristic> heuristics;

        Builder() {
        }

        @Override
        ArgumentChangeFinder.Builder setDistanceFunction(Function<ParameterPair, Double> distanceFunction) {
            if (distanceFunction == null) {
                throw new NullPointerException("Null distanceFunction");
            }
            this.distanceFunction = distanceFunction;
            return this;
        }

        @Override
        ImmutableList.Builder<Heuristic> heuristicsBuilder() {
            if (this.heuristicsBuilder$ == null) {
                this.heuristicsBuilder$ = ImmutableList.builder();
            }
            return this.heuristicsBuilder$;
        }

        @Override
        ArgumentChangeFinder build() {
            if (this.heuristicsBuilder$ != null) {
                this.heuristics = this.heuristicsBuilder$.build();
            } else if (this.heuristics == null) {
                this.heuristics = ImmutableList.of();
            }
            String missing = "";
            if (this.distanceFunction == null) {
                missing = missing + " distanceFunction";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ArgumentChangeFinder(this.distanceFunction, this.heuristics);
        }
    }
}

