/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.Color;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.netbeans.lib.profiler.ui.UIUtils;

final class SQLFormatter {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String DATABASE_PING = messages.getString("SQLFormatter_DatabasePing");
    private static final String PING_TEXT = " - <b>" + DATABASE_PING + "</b>";
    private static String[] keywords = new String[]{"AS", "ALL", "AND", "ASC", "AVG", "BY", "COUNT", "CROSS", "DESC", "DISTINCT", "FROM", "FULL", "GROUP", "HAVING", "INNER", "LEFT", "JOIN", "MAX", "MIN", "NATURAL", "NOT", "ON", "OR", "ORDER", "OUTER", "RIGHT", "SELECT", "SUM", "WHERE", "CREATE TABLE", "ALTER TABLE", "TRUNCATE TABLE", "DROP TABLE", "INSERT INTO", "ALTER SESSION", "DELETE", "UPDATE", "VALUES", "SET", "'[^']*'"};
    private static final Pattern keywordsPattern = Pattern.compile(SQLFormatter.getPattern(keywords), 2);
    private static final String[] pingSQL = new String[]{"^SELECT\\s+1", "^VALUES\\s*\\(\\s*1\\s*\\)"};
    private static final Pattern pingSQLPattern = Pattern.compile(SQLFormatter.getPattern(pingSQL), 2);
    private static String grayHTMLString;

    SQLFormatter() {
    }

    private static String getPattern(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("(");
            if (Character.isLetter(string.charAt(0))) {
                stringBuilder.append("\\b");
                stringBuilder.append(string);
                stringBuilder.append("\\b");
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(")|");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static String format(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        string = SQLFormatter.htmlize(string);
        Matcher matcher = keywordsPattern.matcher(string);
        stringBuilder.append("<html>");
        while (matcher.find()) {
            String string2 = matcher.group();
            stringBuilder.append(string.substring(n, matcher.start()));
            if (string2.startsWith("'")) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append("<b>");
                stringBuilder.append(string2);
                stringBuilder.append("</b>");
            }
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n, string.length()));
        stringBuilder.append(SQLFormatter.checkPingSQL(string));
        stringBuilder.append("</html>");
        String string3 = stringBuilder.toString();
        string3 = string3.replace(")", ")</font>");
        string3 = string3.replace("(", "<font color='" + SQLFormatter.getGrayHTMLString() + "'>(");
        return string3;
    }

    private static String htmlize(String string) {
        return string.replace(">", "&gt;").replace("<", "&lt;");
    }

    private static String checkPingSQL(String string) {
        Matcher matcher = pingSQLPattern.matcher(string);
        if (matcher.find()) {
            return PING_TEXT;
        }
        return "";
    }

    private static String getGrayHTMLString() {
        if (grayHTMLString == null) {
            Color color = UIUtils.getDisabledForeground(new JLabel().getForeground());
            grayHTMLString = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return grayHTMLString;
    }
}

