/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeIntention
extends PyBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TypeIntention.$$$reportNull$$$0(0);
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        this.updateText(false);
        if (this.findOnlySuitableParameter(editor, file) != null) {
            return true;
        }
        if (this.findOnlySuitableFunction(editor, file) != null) {
            this.updateText(true);
            return true;
        }
        return false;
    }

    @Nullable
    protected final PyFunction findOnlySuitableFunction(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeIntention.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(2);
        }
        return TypeIntention.findOnlySuitableFunction(editor, file, input -> !this.isReturnTypeDefined((PyFunction)input));
    }

    @Nullable
    public static PyFunction findOnlySuitableFunction(@NotNull Editor editor, @NotNull PsiFile file, Predicate<PyFunction> condition) {
        PsiElement elementAt;
        if (editor == null) {
            TypeIntention.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(4);
        }
        return (elementAt = TypeIntention.getElementUnderCaret(editor, file)) != null ? (PyFunction)ContainerUtil.getOnlyItem(TypeIntention.findSuitableFunctions(elementAt, condition)) : null;
    }

    @Nullable
    protected final PyNamedParameter findOnlySuitableParameter(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeIntention.$$$reportNull$$$0(5);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(6);
        }
        return (PyNamedParameter)ContainerUtil.getOnlyItem(this.findSuitableParameters(editor, file));
    }

    @NotNull
    private List<PyNamedParameter> findSuitableParameters(@NotNull Editor editor, @NotNull PsiFile file) {
        PyReferenceExpression referenceExpr;
        PsiElement elementAt;
        PyNamedParameter immediateParam;
        if (editor == null) {
            TypeIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(8);
        }
        StreamEx parameters2 = (immediateParam = (PyNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = TypeIntention.getElementUnderCaret(editor, file)), PyNamedParameter.class)) != null ? StreamEx.of((Object)immediateParam) : ((referenceExpr = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class)) != null ? StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)referenceExpr, TypeIntention.getResolveContext(elementAt))).select(PyNamedParameter.class) : StreamEx.empty());
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)file.getProject());
        List list = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)parameters2.filter(param -> !param.isSelf())).filter(param -> PsiTreeUtil.getParentOfType((PsiElement)param, PyLambdaExpression.class) == null)).filter(param -> !index.isInLibraryClasses(param.getContainingFile().getVirtualFile()))).filter(param -> !this.isParamTypeDefined((PyNamedParameter)param))).toList();
        if (list == null) {
            TypeIntention.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static PsiElement getElementUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeIntention.$$$reportNull$$$0(10);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(11);
        }
        int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        return PyUtil.findNonWhitespaceAtOffset(file, offset);
    }

    protected abstract void updateText(boolean var1);

    protected abstract boolean isParamTypeDefined(@NotNull PyNamedParameter var1);

    protected abstract boolean isReturnTypeDefined(@NotNull PyFunction var1);

    @NotNull
    private static List<PyFunction> findSuitableFunctions(@NotNull PsiElement elementAt, @NotNull Predicate<PyFunction> extraCondition) {
        PyFunction immediateDefinition;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(12);
        }
        if (extraCondition == null) {
            TypeIntention.$$$reportNull$$$0(13);
        }
        StreamEx definitions = (immediateDefinition = TypeIntention.findFunctionDefinitionUnderCaret(elementAt)) != null ? StreamEx.of((Object)immediateDefinition) : StreamEx.of(TypeIntention.getCallExpressions(elementAt)).flatMap(call -> StreamEx.of(call.multiResolveCallee(TypeIntention.getResolveContext(elementAt)))).map(result -> result.getElement()).select(PyFunction.class);
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)elementAt.getProject());
        List list = ((StreamEx)((StreamEx)definitions.filter(elem -> !index.isInLibraryClasses(elem.getContainingFile().getVirtualFile()))).filter(extraCondition)).toList();
        if (list == null) {
            TypeIntention.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private static PyFunction findFunctionDefinitionUnderCaret(@NotNull PsiElement elementAt) {
        ASTNode nameNode;
        PyFunction parentFunction;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(15);
        }
        if ((parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class)) != null && (nameNode = parentFunction.getNameNode()) != null) {
            PsiElement prev = elementAt.getContainingFile().findElementAt(elementAt.getTextOffset() - 1);
            if (nameNode.getPsi() == elementAt || nameNode.getPsi() == prev) {
                return parentFunction;
            }
        }
        return null;
    }

    @NotNull
    private static List<PyCallExpression> getCallExpressions(@NotNull PsiElement elementAt) {
        PyExpression assignedValue;
        List calls;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(16);
        }
        PyResolveContext context = TypeIntention.getResolveContext(elementAt);
        PyReferenceExpression referenceExpr = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class);
        if (referenceExpr != null && !(calls = ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)referenceExpr, context)).select(PyTargetExpression.class).filter(target -> context.getTypeEvalContext().maySwitchToAST((PsiElement)target))).map(target -> target.findAssignedValue()).select(PyCallExpression.class).toList()).isEmpty()) {
            List list = calls;
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(17);
            }
            return list;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyAssignmentStatement.class);
        if (assignment != null && (assignedValue = assignment.getAssignedValue()) instanceof PyCallExpression) {
            List<PyCallExpression> list = Collections.singletonList((PyCallExpression)assignedValue);
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(18);
            }
            return list;
        }
        PyCallExpression immediateCall = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyCallExpression.class, (boolean)false);
        if (immediateCall != null) {
            List<PyCallExpression> list = Collections.singletonList(immediateCall);
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<PyCallExpression> list = Collections.emptyList();
        if (list == null) {
            TypeIntention.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static PyResolveContext getResolveContext(@NotNull PsiElement origin) {
        if (origin == null) {
            TypeIntention.$$$reportNull$$$0(21);
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(origin.getProject(), origin.getContainingFile());
        return PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraCondition";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableFunctions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOnlySuitableFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOnlySuitableParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableParameters";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementUnderCaret";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunctions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDefinitionUnderCaret";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResolveContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

