/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class OWLTreePreferences {
    private static OWLTreePreferences instance;
    private static final String TREE_PREFS_KEY = "TREE_PREFERENCES";
    private static final String AUTO_EXPAND_ENABLED_KEY = "AUTO_EXPAND_ENABLED_KEY";
    private static final String CHILD_COUNT_LIMIT_KEY = "AUTO_EXPANSION_CHILD_LIMIT";
    private static final String TREE_DEPTH_LIMIT_KEY = "TREE_DEPTH_LIMIT";
    private static final String TREE_DRAG_AND_DROP_ENABLED_KEY = "TREE_DRAG_AND_DROP_ENABLED";
    private static final String TREE_PAINT_LINES = "TREE_PAINT_LINES";

    public static synchronized OWLTreePreferences getInstance() {
        if (instance == null) {
            instance = new OWLTreePreferences();
        }
        return instance;
    }

    public int getAutoExpansionChildLimit() {
        return OWLTreePreferences.getPreferences().getInt(CHILD_COUNT_LIMIT_KEY, 50);
    }

    public void setAutoExpansionChildLimit(int limit) {
        OWLTreePreferences.getPreferences().putInt(CHILD_COUNT_LIMIT_KEY, limit);
    }

    public int getAutoExpansionDepthLimit() {
        return OWLTreePreferences.getPreferences().getInt(TREE_DEPTH_LIMIT_KEY, 3);
    }

    public void setAutoExpansionDepthLimit(int limit) {
        OWLTreePreferences.getPreferences().putInt(TREE_DEPTH_LIMIT_KEY, limit);
    }

    public boolean isAutoExpandEnabled() {
        return OWLTreePreferences.getPreferences().getBoolean(AUTO_EXPAND_ENABLED_KEY, false);
    }

    public void setAutoExpansionEnabled(boolean enabled) {
        OWLTreePreferences.getPreferences().putBoolean(AUTO_EXPAND_ENABLED_KEY, enabled);
    }

    public boolean isTreeDragAndDropEnabled() {
        return OWLTreePreferences.getPreferences().getBoolean(TREE_DRAG_AND_DROP_ENABLED_KEY, true);
    }

    public void setTreeDragAndDropEnabled(boolean enabled) {
        OWLTreePreferences.getPreferences().putBoolean(TREE_DRAG_AND_DROP_ENABLED_KEY, enabled);
    }

    private static Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(TREE_PREFS_KEY);
    }

    public boolean isPaintLines() {
        return OWLTreePreferences.getPreferences().getBoolean(TREE_PAINT_LINES, true);
    }

    public void setPaintLines(boolean paintLines) {
        OWLTreePreferences.getPreferences().putBoolean(TREE_PAINT_LINES, paintLines);
    }
}

