/*
 * Decompiled with CFR 0.152.
 */
package org.qcschema;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.viewer.Viewer;

public class QCSchemaUnits {
    public static final String version = "QCJSON 0-0-0.Jmol_" + Viewer.getJmolVersion().replace(' ', '_');
    public static final String UNITS_FRACTIONAL = "fractional";
    public static final String UNITS_AU = "au";
    public static final double TOAU_AU = 1.0;
    public static final String UNITS_CM = "cm";
    public static final double TOAU_CM = 1.8897261254578283E8;
    public static final String UNITS_M = "m";
    public static final double TOAU_M = 1.889726125457828E10;
    public static final String UNITS_ANGSTROMS = "angstroms";
    public static final double TOAU_ANGSTROMS = 1.8897261254578281;
    public static final String UNITS_BOHR = "bohr";
    public static final double TOAU_BOHR = 1.0;
    public static final String UNITS_HARTREE = "hartree";
    public static final double TOAU_HARTREE = 1.0;
    public static final String UNITS_EV = "ev";
    public static final double TOAU_EV = 0.0367498438131638;
    public static final String UNITS_CM_1 = "cm-1";
    public static final double TOAU_CM_1 = 4.55633590401805E-6;
    public static final String UNITS_KJ_MOL = "kj/mol";
    public static final double TOAU_KJ_MOL = 3.7943464238284955E-4;
    public static final String UNITS_KCAL_MOL = "kcal/mol";
    public static final double TOAU_KCAL_MOL = 0.0015936254980079682;
    private static final String knownUnits = "cm cm^-1 cm-1 angstroms au atomic units fractional bohrs hartrees ev kj_mol kcal_mol";
    private static Hashtable<String, Double> htConvert = new Hashtable();

    public static double getFactorToAU(String string) {
        switch (knownUnits.indexOf(string.toLowerCase())) {
            case 0: {
                return 1.8897261254578283E8;
            }
            case 1: {
                return 1.889726125457828E10;
            }
            case 3: 
            case 9: {
                return 4.55633590401805E-6;
            }
            case 14: {
                return 1.8897261254578281;
            }
            case 24: 
            case 27: {
                return 1.0;
            }
            case 40: {
                return 0.0;
            }
            case 51: {
                return 1.0;
            }
            case 57: {
                return 1.0;
            }
            case 66: {
                return 0.0367498438131638;
            }
            case 69: {
                return 0.0015936254980079682;
            }
            case 76: {
                return 3.7943464238284955E-4;
            }
        }
        return Double.NaN;
    }

    public static double getUnitConversion(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return 1.0;
        }
        String string3 = string + string2;
        Double d = htConvert.get(string3);
        if (d != null) {
            return d;
        }
        double d2 = Double.NaN;
        try {
            double d3 = QCSchemaUnits.getFactorToAU(string2);
            double d4 = QCSchemaUnits.getFactorToAU(string);
            d2 = d4 / d3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        htConvert.put(string3, d2);
        return d2;
    }

    public static double getConversionFactorTo(ArrayList<Object> arrayList, String string) {
        try {
            double d = QCSchemaUnits.getFactorToAU(string);
            double d2 = QCSchemaUnits.getFactorToAU(arrayList == null ? UNITS_AU : arrayList.get(0).toString());
            if (Double.isNaN(d2)) {
                d2 = Double.parseDouble(arrayList.get(1).toString());
            }
            return d2 / d;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double convertValue(Map<String, Object> map, String string) {
        return QCSchemaUnits.getDouble(map, "value", null) * QCSchemaUnits.getConversionFactor(map, "units", string);
    }

    public static Object getUnitsJSON(String string, boolean bl) {
        Object object;
        String string2;
        double d = QCSchemaUnits.getFactorToAU(string);
        String string3 = !Double.isNaN(d) ? "" + d : (string2 = bl ? "?" : "\"?\"");
        if (bl) {
            String[] stringArray = new String[2];
            stringArray[0] = string;
            object = stringArray;
            stringArray[1] = string2;
        } else {
            object = "[\"" + string + "\"," + string2 + "]";
        }
        return object;
    }

    public static double getConversionFactor(Map<String, Object> map, String string, String string2) {
        ArrayList<Object> arrayList = QCSchemaUnits.getList(map, String.valueOf(string) + "_units");
        String string3 = arrayList == null ? null : arrayList.get(0).toString();
        double d = QCSchemaUnits.getConversionFactorTo(arrayList, string2);
        if (Double.isNaN(d)) {
            System.out.println("units for " + string3 + "? " + string3);
            d = 1.0;
        }
        return d;
    }

    public static double getDouble(Map<String, Object> map, String string, String string2) {
        Object object = map.get(string);
        double d = 1.0;
        if (string2 != null) {
            if (object instanceof Map) {
                return QCSchemaUnits.convertValue((Map)object, string2);
            }
            if (map.containsKey(String.valueOf(string) + "_units")) {
                d = QCSchemaUnits.getConversionFactor(map, string, string2);
            }
        }
        return object == null ? Double.NaN : ((Number)object).doubleValue() * d;
    }

    public static ArrayList<Object> getList(Object object, String string) {
        ArrayList arrayList = (ArrayList)(string == null ? object : ((Map)object).get(string));
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0 || !"_RLE_".equals(arrayList.get(0))) {
            return arrayList;
        }
        ArrayList<Object> arrayList2 = QCSchemaUnits.newList();
        int n2 = 1;
        while (n2 < n) {
            int n3 = ((Number)arrayList.get(n2)).intValue();
            Object e = arrayList.get(++n2);
            int n4 = 0;
            while (n4 < n3) {
                arrayList2.add(e);
                ++n4;
            }
            ++n2;
        }
        return arrayList2;
    }

    protected static ArrayList<Object> newList() {
        return new ArrayList<Object>();
    }

    public static double[] getDoubleArray(Object object, String string) {
        ArrayList<Object> arrayList = QCSchemaUnits.getList(object, string);
        if (arrayList == null) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        int n = dArray.length;
        while (--n >= 0) {
            try {
                dArray[n] = ((Number)arrayList.get(n)).doubleValue();
            }
            catch (Exception exception) {
                dArray[n] = Double.NaN;
            }
        }
        return dArray;
    }

    public static int[] getIntArray(Object object, String string) {
        ArrayList<Object> arrayList = QCSchemaUnits.getList(object, string);
        if (arrayList != null) {
            try {
                int[] nArray = new int[arrayList.size()];
                int n = nArray.length;
                while (--n >= 0) {
                    nArray[n] = ((Number)arrayList.get(n)).intValue();
                }
                return nArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getStringArray(Object object, String string) {
        ArrayList<Object> arrayList = QCSchemaUnits.getList(object, string);
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            Object object2 = arrayList.get(n);
            String string2 = stringArray[n] = object2 == null ? null : arrayList.get(n).toString();
        }
        return stringArray;
    }
}

