/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javajs.util.PT;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.LogPanel;

public class Test
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton StateButton;
    JButton FileButton;
    JButton PathButton;
    JButton movetoTime;
    JButton StringtoScriptButton;
    JTextField appletPath;
    ArrayListTransferHandler arrayListHandler;
    JFileChooser fc;
    Viewer vwr;

    Test(Viewer viewer) {
        this.vwr = viewer;
    }

    public JComponent panel() {
        JLabel jLabel = new JLabel("Buttons to test getting info from Jmol Application");
        this.StateButton = new JButton("Get Application State...");
        this.StateButton.addActionListener(this);
        this.FileButton = new JButton("Get name of open file...");
        this.FileButton.addActionListener(this);
        this.PathButton = new JButton("Get Path to open file...");
        this.PathButton.addActionListener(this);
        this.movetoTime = new JButton("Insert 5 seconds for moveto, rotate and zoom...");
        this.movetoTime.addActionListener(this);
        this.StringtoScriptButton = new JButton("Save a string as a script");
        this.StringtoScriptButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.StateButton);
        jPanel.add(this.FileButton);
        jPanel.add(this.PathButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.movetoTime);
        jPanel2.add(this.StringtoScriptButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(10, 1));
        jPanel3.add(jLabel);
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.StateButton) {
            string = null;
            string = this.vwr.getStateInfo();
            if (string == null) {
                LogPanel.log("Something didn't work when selecting the State Button in Test module");
            }
            LogPanel.log(string);
        }
        if (actionEvent.getSource() == this.FileButton) {
            string = null;
            string = this.vwr.fm.getFileName();
            if (string == null) {
                LogPanel.log("Something didn't work when selecting the file button in Test module");
            } else {
                LogPanel.log(string);
            }
        }
        if (actionEvent.getSource() == this.PathButton) {
            string = null;
            string = this.vwr.fm.getFullPathName(false);
            if (string == null) {
                LogPanel.log("Something didn't work when selecting the Path button in Test module");
            } else {
                LogPanel.log(string);
            }
        }
        if (actionEvent.getSource() == this.movetoTime) {
            string = null;
            string = this.vwr.getStateInfo();
            if (string == null) {
                LogPanel.log("Something didn't work when reading the state while trying to add a moveto time.");
            }
            string = PT.rep(string, "set refreshing false;", "set refreshing true;");
            string = PT.rep(string, "moveto /* time, axisAngle */ 0.0", "moveto /* time, axisAngle */ 5.0");
            LogPanel.log("The state below should have a 5 second moveto time...");
            LogPanel.log(string);
        }
        if (actionEvent.getSource() == this.StringtoScriptButton) {
            string = "This is a test string to stand in for the script;";
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream("Test.scpt"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogPanel.log("Open file error in StringtoScriptButton");
            }
            printStream.print(string);
            printStream.close();
            LogPanel.log("The file Test.scpt should have been written to the default directory.");
        }
    }
}

