/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Matrix;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSRdr;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

class Subsystem {
    private MSRdr msRdr;
    private String code;
    private int d;
    private Matrix w;
    private SymmetryInterface symmetry;
    private Matrix[] modMatrices;
    private boolean isFinalized;

    Subsystem(MSRdr mSRdr, String string, Matrix matrix) {
        this.msRdr = mSRdr;
        this.code = string;
        this.w = matrix;
        this.d = matrix.getArray().length - 3;
    }

    public SymmetryInterface getSymmetry() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.symmetry;
    }

    public Matrix[] getModMatrices() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.modMatrices;
    }

    private void setSymmetry(boolean bl) {
        Logger.info("[subsystem " + this.code + "]");
        Matrix matrix = this.w.inverse();
        Logger.info("w=" + this.w);
        Logger.info("w_inv=" + matrix);
        Matrix matrix2 = this.w.getSubmatrix(0, 0, 3, 3);
        Matrix matrix3 = this.w.getSubmatrix(3, 0, this.d, 3);
        Matrix matrix4 = this.w.getSubmatrix(0, 3, 3, this.d);
        Matrix matrix5 = this.w.getSubmatrix(3, 3, this.d, this.d);
        Matrix matrix6 = this.msRdr.getSigma();
        Matrix matrix7 = matrix5.mul(matrix6).add(matrix3).mul(matrix4.mul(matrix6).add(matrix2).inverse());
        Matrix matrix8 = matrix5.sub(matrix7.mul(matrix4));
        Logger.info("sigma_nu = " + matrix7);
        SymmetryInterface symmetryInterface = this.msRdr.cr.asc.getSymmetry();
        T3[] t3Array = symmetryInterface.getUnitCellVectors();
        T3[] t3Array2 = SimpleUnitCell.getReciprocal(t3Array, null, 1.0f);
        Matrix matrix9 = new Matrix(null, 3 + this.d, 3);
        Matrix matrix10 = new Matrix(null, 3, 3);
        double[][] dArray = matrix9.getArray();
        double[][] dArray2 = matrix10.getArray();
        int n = 0;
        while (n < 3) {
            dArray2[n] = new double[]{t3Array2[n + 1].x, t3Array2[n + 1].y, t3Array2[n + 1].z};
            dArray[n] = dArray2[n];
            ++n;
        }
        Matrix matrix11 = matrix6.mul(matrix10);
        double[][] dArray3 = matrix11.getArray();
        int n2 = 0;
        while (n2 < this.d) {
            dArray[n2 + 3] = dArray3[n2];
            ++n2;
        }
        dArray3 = this.w.mul(matrix9).getArray();
        T3[] t3Array3 = new T3[4];
        t3Array3[0] = t3Array[0];
        int n3 = 0;
        while (n3 < 3) {
            t3Array3[n3 + 1] = V3.new3((float)dArray3[n3][0], (float)dArray3[n3][1], (float)dArray3[n3][2]);
            ++n3;
        }
        t3Array3 = SimpleUnitCell.getReciprocal(t3Array3, null, 1.0f);
        this.symmetry = ((Symmetry)this.msRdr.cr.getInterface("org.jmol.symmetry.Symmetry")).getUnitCell(t3Array3, false, null);
        this.modMatrices = new Matrix[]{matrix7, matrix8};
        if (!bl) {
            return;
        }
        this.isFinalized = true;
        Logger.info("unit cell parameters: " + this.symmetry.getUnitCellInfo());
        this.symmetry.createSpaceGroup(-1, "[subsystem " + this.code + "]", new Lst(), this.d);
        n3 = symmetryInterface.getSpaceGroupOperationCount();
        int n4 = 0;
        while (n4 < n3) {
            Map.Entry<String, Subsystem> entry2;
            Matrix matrix12 = symmetryInterface.getOperationRsVs(n4);
            Matrix matrix13 = matrix12.getRotation();
            Matrix matrix14 = matrix12.getTranslation();
            Matrix matrix15 = this.w.mul(matrix13).mul(matrix);
            Matrix matrix16 = this.w.mul(matrix14);
            String string = this.code;
            if (this.isMixed(matrix15)) {
                for (Map.Entry<String, Subsystem> entry2 : this.msRdr.htSubsystems.entrySet()) {
                    Matrix matrix17;
                    Subsystem subsystem = (Subsystem)entry2.getValue();
                    if (subsystem == this || this.isMixed(matrix17 = subsystem.w.mul(matrix13).mul(matrix))) continue;
                    matrix15 = matrix17;
                    matrix16 = subsystem.w.mul(matrix14);
                    string = subsystem.code;
                    break;
                }
            }
            entry2 = this.symmetry.addOp(string, matrix15, matrix16, matrix7);
            Logger.info(String.valueOf(this.code) + "." + (n4 + 1) + (this.code.equals(string) ? "   " : ">" + string + " ") + (String)((Object)entry2));
            ++n4;
        }
    }

    private boolean isMixed(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        int n = 3;
        while (--n >= 0) {
            int n2 = 3 + this.d;
            while (--n2 >= 3) {
                if (dArray[n][n2] == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Subsystem " + this.code + "\n" + this.w;
    }
}

