/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.methods;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Iterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.runtime.Macro;
import org.codehaus.groovy.macro.runtime.MacroBuilder;
import org.codehaus.groovy.macro.runtime.MacroContext;
import org.codehaus.groovy.syntax.SyntaxException;

public class MacroGroovyMethods {
    public static final String DOLLAR_VALUE = "$v";

    public static <T> T macro(Object self, @DelegatesTo(value=MacroValuePlaceholder.class) Closure cl) {
        throw new IllegalStateException("MacroGroovyMethods.macro(Closure) should never be called at runtime. Are you sure you are using it correctly?");
    }

    @Macro
    public static Expression macro(MacroContext macroContext, ClosureExpression closureExpression) {
        return MacroGroovyMethods.macro(macroContext, new ConstantExpression(false, true), closureExpression);
    }

    public static <T> T macro(Object self, boolean asIs, @DelegatesTo(value=MacroValuePlaceholder.class) Closure cl) {
        throw new IllegalStateException("MacroGroovyMethods.macro(boolean, Closure) should never be called at runtime. Are you sure you are using it correctly?");
    }

    @Macro
    public static Expression macro(MacroContext macroContext, ConstantExpression asIsConstantExpression, ClosureExpression closureExpression) {
        return MacroGroovyMethods.macro(macroContext, null, asIsConstantExpression, closureExpression);
    }

    public static <T> T macro(Object self, CompilePhase compilePhase, @DelegatesTo(value=MacroValuePlaceholder.class) Closure cl) {
        throw new IllegalStateException("MacroGroovyMethods.macro(CompilePhase, Closure) should never be called at runtime. Are you sure you are using it correctly?");
    }

    @Macro
    public static Expression macro(MacroContext macroContext, PropertyExpression phaseExpression, ClosureExpression closureExpression) {
        return MacroGroovyMethods.macro(macroContext, phaseExpression, new ConstantExpression(false, true), closureExpression);
    }

    public static <T> T macro(Object self, CompilePhase compilePhase, boolean asIs, @DelegatesTo(value=MacroValuePlaceholder.class) Closure cl) {
        throw new IllegalStateException("MacroGroovyMethods.macro(CompilePhase, boolean, Closure) should never be called at runtime. Are you sure you are using it correctly?");
    }

    @Macro
    public static Expression macro(MacroContext macroContext, PropertyExpression phaseExpression, ConstantExpression asIsConstantExpression, ClosureExpression closureExpression) {
        String source;
        if (closureExpression.getParameters() != null && closureExpression.getParameters().length > 0) {
            macroContext.getSourceUnit().addError(new SyntaxException("Macro closure arguments are not allowed\n", closureExpression));
            return macroContext.getCall();
        }
        try {
            source = ClosureUtils.convertClosureToSource(macroContext.getSourceUnit().getSource(), closureExpression);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BlockStatement closureBlock = (BlockStatement)closureExpression.getCode();
        Boolean asIs = (Boolean)asIsConstantExpression.getValue();
        return GeneralUtils.callX(GeneralUtils.propX((Expression)GeneralUtils.classX(ClassHelper.makeWithoutCaching(MacroBuilder.class, false)), "INSTANCE"), "macro", (Expression)GeneralUtils.args(phaseExpression != null ? phaseExpression : GeneralUtils.constX(null), asIsConstantExpression, GeneralUtils.constX(source), MacroGroovyMethods.buildSubstitutions(macroContext.getSourceUnit(), closureExpression), GeneralUtils.classX(ClassHelper.makeWithoutCaching(MacroBuilder.getMacroValue(closureBlock, asIs).getClass(), false))));
    }

    public static ListExpression buildSubstitutions(final SourceUnit source, ASTNode expr) {
        final ListExpression listExpression = new ListExpression();
        ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

            @Override
            protected SourceUnit getSourceUnit() {
                return null;
            }

            @Override
            public void visitClass(ClassNode node) {
                super.visitClass(node);
                Iterator<InnerClassNode> it = node.getInnerClasses();
                while (it.hasNext()) {
                    InnerClassNode next = it.next();
                    this.visitClass(next);
                }
            }

            @Override
            public void visitMethodCallExpression(MethodCallExpression call) {
                super.visitMethodCallExpression(call);
                if (MacroGroovyMethods.DOLLAR_VALUE.equals(call.getMethodAsString())) {
                    ClosureExpression substitutionClosureExpression = MacroGroovyMethods.getClosureArgument(source, call);
                    if (substitutionClosureExpression == null) {
                        return;
                    }
                    Statement code = substitutionClosureExpression.getCode();
                    if (code instanceof BlockStatement) {
                        ((BlockStatement)code).setVariableScope(null);
                    }
                    listExpression.addExpression(substitutionClosureExpression);
                }
            }
        };
        if (expr instanceof ClassNode) {
            visitor.visitClass((ClassNode)expr);
        } else {
            expr.visit(visitor);
        }
        return listExpression;
    }

    protected static TupleExpression getMacroArguments(SourceUnit source, MethodCallExpression call) {
        Expression macroCallArguments = call.getArguments();
        if (macroCallArguments == null) {
            source.addError(new SyntaxException("Call should have arguments\n", call));
            return null;
        }
        if (!(macroCallArguments instanceof TupleExpression)) {
            source.addError(new SyntaxException("Call should have TupleExpression as arguments\n", macroCallArguments));
            return null;
        }
        TupleExpression tupleArguments = (TupleExpression)macroCallArguments;
        if (tupleArguments.getExpressions() == null) {
            source.addError(new SyntaxException("Call arguments should have expressions\n", tupleArguments));
            return null;
        }
        return tupleArguments;
    }

    protected static ClosureExpression getClosureArgument(SourceUnit source, MethodCallExpression call) {
        int size;
        TupleExpression tupleArguments = MacroGroovyMethods.getMacroArguments(source, call);
        int n = size = tupleArguments == null ? -1 : tupleArguments.getExpressions().size();
        if (size < 1) {
            source.addError(new SyntaxException("Call arguments should have at least one argument\n", tupleArguments));
            return null;
        }
        Expression result = tupleArguments.getExpression(size - 1);
        if (!(result instanceof ClosureExpression)) {
            source.addError(new SyntaxException("Last call argument should be a closure\n", result));
            return null;
        }
        return (ClosureExpression)result;
    }

    public static class MacroValuePlaceholder {
        public static Object $v(Closure cl) {
            return null;
        }
    }
}

