/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class ClassMemberContext
extends StatementContext {
    private Trigger triggerType;
    private IType[] types;
    private int elementStart;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        int totalLength = statementText.length();
        this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, totalLength);
        this.elementStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, this.elementStart, true);
        this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart);
        if (this.elementStart <= 2) {
            return false;
        }
        String triggerText = statementText.subSequence(this.elementStart - 2, this.elementStart).toString();
        if (triggerText.equals("->")) {
            this.triggerType = Trigger.OBJECT;
        } else if (triggerText.equals("::")) {
            this.triggerType = Trigger.CLASS;
        } else {
            return false;
        }
        ArrayList<IType> tmpTypes = new ArrayList<IType>();
        try {
            IModelElement enclosingElement = this.getEnclosingElement();
            while (enclosingElement instanceof IMethod) {
                if (!((enclosingElement = enclosingElement.getParent()) instanceof IField)) continue;
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IType && PHPFlags.isAnonymous(((IType)enclosingElement).getFlags())) {
                tmpTypes.add((IType)enclosingElement);
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        tmpTypes.addAll(Arrays.asList(this.getCompanion().getLeftHandType(this, !this.isInUseTraitStatement())));
        this.types = tmpTypes.toArray(new IType[0]);
        return true;
    }

    public int getElementStart() {
        return this.elementStart;
    }

    public IType[] getLhsTypes() {
        return this.types;
    }

    public Trigger getTriggerType() {
        return this.triggerType;
    }

    @Override
    public int getReplacementEnd() throws BadLocationException {
        ITextRegion phpToken = this.getCompanion().getPHPToken();
        if (phpToken.getType() == "PHP_OBJECT_OPERATOR" || phpToken.getType() == "PHP_PAAMAYIM_NEKUDOTAYIM") {
            IPHPScriptRegion phpScriptRegion = this.getCompanion().getPHPScriptRegion();
            ITextRegion nextRegion = phpScriptRegion.getPHPToken(phpToken.getEnd());
            if (phpToken.getTextLength() == phpToken.getLength()) {
                int addOffset = 0;
                addOffset = nextRegion.getType() == "PHP_TOKEN" || nextRegion.getType() == "PHP_SEMICOLON" ? phpToken.getEnd() : nextRegion.getTextEnd();
                return this.getCompanion().getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + addOffset;
            }
        }
        return super.getReplacementEnd();
    }

    public static enum Trigger {
        CLASS("::"),
        OBJECT("->");

        String name;

        private Trigger(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

