/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.ui.BasicFacetedProjectWizardFirstPage;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;

public class BasicFacetedProjectWizard
extends ModifyFacetedProjectWizard
implements INewWizard {
    private IWizardPage firstPage;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public BasicFacetedProjectWizard() {
        this.setWindowTitle(Resources.wizardTitle);
        this.setDefaultPageImageDescriptor(FacetUiPlugin.getImageDescriptor("images/newprj-wizban.png"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWizardPage getFirstPage() {
        return this.firstPage;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected IWizardPage createFirstPage() {
        BasicFacetedProjectWizardFirstPage firstPage = new BasicFacetedProjectWizardFirstPage("first.page");
        firstPage.setTitle(Resources.wizardTitle);
        firstPage.setDescription(Resources.firstPageDescription);
        return firstPage;
    }

    protected String getProjectName() {
        return ((WizardNewProjectCreationPage)this.getFirstPage()).getProjectName();
    }

    protected IPath getProjectLocation() {
        IPath location = ((WizardNewProjectCreationPage)this.getFirstPage()).getLocationPath();
        if (location != null && location.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
            location = null;
        }
        return location;
    }

    public void addPages() {
        this.firstPage = this.createFirstPage();
        this.addPage(this.firstPage);
        super.addPages();
    }

    public IWizardPage[] getPages() {
        IWizardPage[] base = super.getPages();
        IWizardPage[] pages = new IWizardPage[base.length + 1];
        pages[0] = this.firstPage;
        System.arraycopy(base, 0, pages, 1, base.length);
        return pages;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.firstPage) {
            IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
            fpjwc.setProjectName(this.getProjectName());
            fpjwc.setProjectLocation(this.getProjectLocation());
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && super.canFinish();
    }

    public boolean performFinish() {
        super.performFinish();
        if (this.firstPage instanceof WizardNewProjectCreationPage) {
            IProject project = this.getFacetedProjectWorkingCopy().getProject();
            WizardNewProjectCreationPage mainPage = (WizardNewProjectCreationPage)this.firstPage;
            IWorkingSet[] workingSets = mainPage.getSelectedWorkingSets();
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String wizardTitle;
        public static String firstPageDescription;

        static {
            Resources.initializeMessages((String)BasicFacetedProjectWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

