/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleMaterializedView;
import org.jkiss.dbeaver.ext.oracle.tools.maintenance.OracleMaintenanceDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class OracleToolRefreshMView
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, OracleMaterializedView.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends OracleMaintenanceDialog<OracleMaterializedView> {
        private Button methodFast;
        private Button methodForce;
        private Button methodComplete;
        private Button methodAlways;
        private Button methodRecomputePartitions;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<OracleMaterializedView> selectedTables) {
            super(partSite, "Refresh materialized view(s)", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, OracleMaterializedView object) {
            String method = "";
            if (this.methodFast.getSelection()) {
                method = String.valueOf(method) + "f";
            }
            if (this.methodForce.getSelection()) {
                method = String.valueOf(method) + "?";
            }
            if (this.methodComplete.getSelection()) {
                method = String.valueOf(method) + "c";
            }
            if (this.methodAlways.getSelection()) {
                method = String.valueOf(method) + "a";
            }
            if (this.methodRecomputePartitions.getSelection()) {
                method = String.valueOf(method) + "p";
            }
            StringBuilder sql = new StringBuilder();
            sql.append("CALL DBMS_MVIEW.REFRESH('").append(object.getFullyQualifiedName(DBPEvaluationContext.DDL)).append("',");
            sql.append("'").append(method).append("'");
            sql.append(")");
            lines.add(sql.toString());
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.methodFast = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Fast", (String)"Fast refresh", (boolean)false, (int)1);
            this.methodFast.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.methodForce = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Force", (String)"Force refresh", (boolean)false, (int)1);
            this.methodForce.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.methodComplete = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Complete", (String)"Complete refresh", (boolean)false, (int)1);
            this.methodComplete.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.methodAlways = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Always", (String)"Always refresh", (boolean)false, (int)1);
            this.methodAlways.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.methodRecomputePartitions = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Recompute partitions", (String)"Recompute the rows in the materialized view affected by changed partitions in the detail tables", (boolean)false, (int)1);
            this.methodRecomputePartitions.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }
    }
}

