/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class ActiveWizardDialog
extends WizardDialog {
    private Set<String> resizedShells = new HashSet<String>();
    private boolean adaptContainerSizeToPages = false;

    public ActiveWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        this(window, wizard, null);
    }

    public ActiveWizardDialog(IWorkbenchWindow window, IWizard wizard, IStructuredSelection selection) {
        super(window.getShell(), wizard);
        if (wizard instanceof IWorkbenchWizard) {
            ISelectionService selectionService;
            if (selection == null && (selectionService = window.getSelectionService()) != null && selectionService.getSelection() instanceof IStructuredSelection) {
                selection = (IStructuredSelection)selectionService.getSelection();
            }
            ((IWorkbenchWizard)wizard).init(window.getWorkbench(), selection);
        }
        this.addPageChangingListener(event -> {
            if (event.getCurrentPage() instanceof ActiveWizardPage) {
                ((ActiveWizardPage)((Object)((Object)event.getCurrentPage()))).deactivatePage();
            }
        });
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings("DBeaver.ActiveWizardDialog." + this.getWizard().getClass().getSimpleName());
    }

    public void setAdaptContainerSizeToPages(boolean adaptContainerSizeToPages) {
        this.adaptContainerSizeToPages = adaptContainerSizeToPages;
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        if (this.adaptContainerSizeToPages && !this.resizedShells.contains(page.getName())) {
            UIUtils.resizeShell(this.getWizard().getContainer().getShell());
            this.resizedShells.add(page.getName());
        }
    }
}

