/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceOrigin;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataSourceRegistry
implements DBPDataSourceRegistry {
    @Deprecated
    public static final String DEFAULT_AUTO_COMMIT = "default.autocommit";
    @Deprecated
    public static final String DEFAULT_ISOLATION = "default.isolation";
    @Deprecated
    public static final String DEFAULT_ACTIVE_OBJECT = "default.activeObject";
    private static final long DISCONNECT_ALL_TIMEOUT = 5000L;
    private static final Log log = Log.getLog(DataSourceRegistry.class);
    public static final String OLD_CONFIG_FILE_NAME = "data-sources.xml";
    private static PasswordEncrypter ENCRYPTOR = new SimpleStringEncrypter();
    private final DBPPlatform platform;
    private final IProject project;
    private final Map<IFile, DataSourceOrigin> origins = new LinkedHashMap<IFile, DataSourceOrigin>();
    private final List<DataSourceDescriptor> dataSources = new ArrayList<DataSourceDescriptor>();
    private final List<DBPEventListener> dataSourceListeners = new ArrayList<DBPEventListener>();
    private final List<DataSourceFolder> dataSourceFolders = new ArrayList<DataSourceFolder>();
    private final List<DBSObjectFilter> savedFilters = new ArrayList<DBSObjectFilter>();
    private volatile boolean saveInProgress = false;

    public DataSourceRegistry(DBPPlatform platform, IProject project) {
        this.platform = platform;
        this.project = project;
        this.loadDataSources(false);
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, true);
    }

    public DataSourceRegistry(DataSourceRegistry source, IProject project, boolean copyDataSources) {
        this.platform = source.platform;
        this.project = project;
        if (copyDataSources) {
            for (DataSourceDescriptor ds : source.dataSources) {
                this.dataSources.add(new DataSourceDescriptor(ds, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, false);
        List<Object> list = this.dataSourceListeners;
        synchronized (list) {
            if (!this.dataSourceListeners.isEmpty()) {
                log.warn((Object)("Some data source listeners are still registered: " + this.dataSourceListeners));
            }
            this.dataSourceListeners.clear();
        }
        this.closeConnections(5000L);
        list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources) {
                dataSourceDescriptor.dispose();
            }
            this.dataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(long waitTime) {
        boolean hasConnections = false;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dataSource : this.dataSources) {
                if (!dataSource.isConnected()) continue;
                hasConnections = true;
                break;
            }
        }
        if (!hasConnections) {
            return;
        }
        DisconnectTask disconnectTask = new DisconnectTask();
        if (!RuntimeUtils.runTask((DBRRunnableWithProgress)disconnectTask, (String)"Disconnect from data sources", (long)waitTime)) {
            log.warn((Object)("Some data source connections wasn't closed on shutdown in " + waitTime + "ms. Probably network timeout occurred."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceOrigin getDefaultOrigin() {
        Map<IFile, DataSourceOrigin> map = this.origins;
        synchronized (map) {
            for (DataSourceOrigin origin : this.origins.values()) {
                if (!origin.isDefault()) continue;
                return origin;
            }
            IFile defFile = this.project.getFile(".dbeaver-data-sources.xml");
            DataSourceOrigin origin = new DataSourceOrigin(defFile, true);
            this.origins.put(defFile, origin);
            return origin;
        }
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(String id) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (!dsd.getId().equals(id)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(DBPDataSource dataSource) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (dsd.getDataSource() != dataSource) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor findDataSourceByName(String name) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (!dsd.getName().equals(name)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSourceDescriptor> getDataSources() {
        List dsCopy;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            dsCopy = CommonUtils.copyList(this.dataSources);
        }
        dsCopy.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return dsCopy;
    }

    public DBPDataSourceContainer createDataSource(DBPDriver driver, DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, DataSourceDescriptor.generateNewId(driver), (DriverDescriptor)driver, connConfig);
    }

    public DBPDataSourceContainer createDataSource(DBPDataSourceContainer source) {
        DataSourceDescriptor newDS = new DataSourceDescriptor((DataSourceDescriptor)source);
        newDS.setId(DataSourceDescriptor.generateNewId(source.getDriver()));
        return newDS;
    }

    public List<? extends DBPDataSourceFolder> getAllFolders() {
        return this.dataSourceFolders;
    }

    public List<DataSourceFolder> getRootFolders() {
        ArrayList<DataSourceFolder> rootFolders = new ArrayList<DataSourceFolder>();
        for (DataSourceFolder folder : this.dataSourceFolders) {
            if (folder.getParent() != null) continue;
            rootFolders.add(folder);
        }
        return rootFolders;
    }

    public DataSourceFolder addFolder(DBPDataSourceFolder parent, String name) {
        DataSourceFolder folder = new DataSourceFolder(this, (DataSourceFolder)parent, name, null);
        this.dataSourceFolders.add(folder);
        return folder;
    }

    public void removeFolder(DBPDataSourceFolder folder, boolean dropContents) {
        DataSourceFolder folderImpl = (DataSourceFolder)folder;
        DataSourceFolder[] dataSourceFolderArray = folderImpl.getChildren();
        int n = dataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder child = dataSourceFolderArray[n2];
            this.removeFolder(child, dropContents);
            ++n2;
        }
        DBPDataSourceFolder parent = folder.getParent();
        if (parent != null) {
            folderImpl.setParent(null);
        }
        for (DataSourceDescriptor ds : this.dataSources) {
            if (ds.getFolder() != folder) continue;
            if (dropContents) {
                this.removeDataSource(ds);
                continue;
            }
            ds.setFolder(parent);
        }
        this.dataSourceFolders.remove(folderImpl);
    }

    public DBPDataSourceRegistry createCopy(IProject project, boolean copyDataSources) {
        return new DataSourceRegistry(this, project, copyDataSources);
    }

    private DataSourceFolder findRootFolder(String name) {
        for (DataSourceFolder root : this.getRootFolders()) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    public DBPDataSourceFolder getFolder(String path) {
        return this.findFolderByPath(path, true);
    }

    private DataSourceFolder findFolderByPath(String path, boolean create) {
        DataSourceFolder parent = null;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder folder;
            String name = stringArray[n2];
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.findRootFolder(name) : parent.getChild(name);
            if (folder == null) {
                if (!create) {
                    log.warn((Object)("Folder '" + path + "' not found"));
                    break;
                }
                folder = this.addFolder(parent, name);
            }
            parent = folder;
            ++n2;
        }
        return parent;
    }

    @Nullable
    public DBSObjectFilter getSavedFilter(String name) {
        for (DBSObjectFilter filter : this.savedFilters) {
            if (!CommonUtils.equalObjects((Object)filter.getName(), (Object)name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public List<DBSObjectFilter> getSavedFilters() {
        return this.savedFilters;
    }

    public void updateSavedFilter(DBSObjectFilter filter) {
        DBSObjectFilter filterCopy = new DBSObjectFilter(filter);
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filter.getName())) {
                this.savedFilters.set(i, filterCopy);
                return;
            }
            ++i;
        }
        this.savedFilters.add(filterCopy);
    }

    public void removeSavedFilter(String filterName) {
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filterName)) {
                this.savedFilters.remove(i);
                continue;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSource(DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            this.dataSources.add(descriptor);
        }
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        this.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)descriptor, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            this.dataSources.remove(descriptor);
        }
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        try {
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSource);
        }
        finally {
            descriptor.dispose();
        }
    }

    public void updateDataSource(DBPDataSourceContainer dataSource) {
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSource);
    }

    public void flushConfig() {
        this.saveDataSources();
    }

    public void refreshConfig() {
        if (!this.saveInProgress) {
            this.loadDataSources(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceListener(DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSourceListener(DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            return this.dataSourceListeners.remove(listener);
        }
    }

    private void fireDataSourceEvent(DBPEvent.Action action, DBSObject object) {
        this.notifyDataSourceListeners(new DBPEvent(action, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataSourceListeners(final DBPEvent event) {
        ArrayList<DBPEventListener> listeners;
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            if (this.dataSourceListeners.isEmpty()) {
                return;
            }
            listeners = new ArrayList<DBPEventListener>(this.dataSourceListeners);
        }
        new Job("Notify datasource events"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (DBPEventListener listener : listeners) {
                    listener.handleDataSourceEvent(event);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node("dbeaver").node("datasources");
    }

    public static List<DBPDataSourceContainer> getAllDataSources() {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        for (IProject project : DBWorkbench.getPlatform().getLiveProjects()) {
            DBPDataSourceRegistry registry;
            if (!project.isOpen() || (registry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(project)) == null) continue;
            result.addAll(registry.getDataSources());
        }
        return result;
    }

    private void loadDataSources(boolean refresh) {
        if (!this.project.isOpen()) {
            return;
        }
        this.savedFilters.clear();
        ParseResults parseResults = new ParseResults();
        try {
            IResource[] iResourceArray = this.project.members(8);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    IFile file = (IFile)res;
                    if (res.getName().startsWith(".dbeaver-data-sources") && res.getName().endsWith(".xml") && file.exists() && file.exists()) {
                        this.loadDataSources(file, refresh, parseResults);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)"Error reading datasources configuration", (Throwable)e);
        }
        if (refresh) {
            for (DataSourceDescriptor ds : parseResults.updatedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)ds);
            }
            for (DataSourceDescriptor ds : parseResults.addedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)ds);
            }
            ArrayList<DataSourceDescriptor> removedDataSource = new ArrayList<DataSourceDescriptor>();
            for (DataSourceDescriptor ds : this.dataSources) {
                if (parseResults.addedDataSources.contains(ds) || parseResults.updatedDataSources.contains(ds)) continue;
                removedDataSource.add(ds);
            }
            for (DataSourceDescriptor ds : removedDataSource) {
                this.dataSources.remove(ds);
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)ds);
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSources(IFile fromFile, boolean refresh, ParseResults parseResults) {
        DataSourceOrigin origin;
        boolean extraConfig = !fromFile.getName().equalsIgnoreCase(".dbeaver-data-sources.xml");
        Object object = this.origins;
        synchronized (object) {
            origin = this.origins.get(fromFile);
            if (origin == null) {
                origin = new DataSourceOrigin(fromFile, !extraConfig);
                this.origins.put(fromFile, origin);
            }
        }
        if (!fromFile.exists()) {
            return;
        }
        try {
            object = null;
            Object var7_11 = null;
            try (InputStream is = fromFile.getContents(true);){
                this.loadDataSources(is, origin, refresh, parseResults);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (DBException ex) {
            log.warn((Object)("Error loading datasource config from " + fromFile.getFullPath()), (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn((Object)"IO error", (Throwable)ex);
        }
        catch (CoreException e) {
            log.warn((Object)"Resource error", (Throwable)e);
        }
    }

    private void loadDataSources(InputStream is, DataSourceOrigin origin, boolean refresh, ParseResults parseResults) throws DBException, IOException {
        SAXReader parser = new SAXReader(is);
        try {
            DataSourcesParser dsp = new DataSourcesParser(origin, refresh, parseResults);
            parser.parse((SAXListener)dsp);
        }
        catch (XMLException ex) {
            throw new DBException("Datasource config parse error", (Throwable)ex);
        }
        this.updateProjectNature();
    }

    private void saveDataSources() {
        this.updateProjectNature();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.saveInProgress = true;
        try {
            for (DataSourceOrigin origin : this.origins.values()) {
                List<DataSourceDescriptor> localDataSources = this.getDataSources(origin);
                IFile configFile = origin.getSourceFile();
                try {
                    if (localDataSources.isEmpty()) {
                        configFile.delete(true, false, (IProgressMonitor)progressMonitor);
                    } else {
                        ByteArrayOutputStream tempStream = new ByteArrayOutputStream(10000);
                        try {
                            XMLBuilder xml;
                            block36: {
                                xml = new XMLBuilder((OutputStream)tempStream, "UTF-8");
                                xml.setButify(true);
                                Throwable throwable = null;
                                Object var9_13 = null;
                                try (XMLBuilder.Element el1 = xml.startElement("data-sources");){
                                    if (origin.isDefault()) {
                                        for (DataSourceFolder folder : this.dataSourceFolders) {
                                            this.saveFolder(xml, folder);
                                        }
                                    }
                                    for (DataSourceDescriptor dataSource : localDataSources) {
                                        if (dataSource.isTemporary()) continue;
                                        this.saveDataSource(xml, dataSource);
                                    }
                                    if (!origin.isDefault()) break block36;
                                    Throwable throwable2 = null;
                                    Iterator<Object> iterator = null;
                                    try (XMLBuilder.Element ignored = xml.startElement("filters");){
                                        for (DBSObjectFilter cf : this.savedFilters) {
                                            if (cf.isEmpty()) continue;
                                            this.saveObjectFiler(xml, null, null, cf);
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            xml.flush();
                        }
                        catch (IOException ex) {
                            log.warn((Object)"IO error while saving datasources", (Throwable)ex);
                        }
                        ByteArrayInputStream ifs = new ByteArrayInputStream(tempStream.toByteArray());
                        if (!configFile.exists()) {
                            configFile.create((InputStream)ifs, true, (IProgressMonitor)progressMonitor);
                            configFile.setHidden(true);
                        } else {
                            configFile.setContents((InputStream)ifs, true, false, (IProgressMonitor)progressMonitor);
                        }
                    }
                    try {
                        this.getSecurePreferences().flush();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error saving secured preferences", e);
                    }
                }
                catch (CoreException ex) {
                    log.error((Object)"Error saving datasources configuration", (Throwable)ex);
                }
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSourceDescriptor> getDataSources(DataSourceOrigin origin) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor ds : this.dataSources) {
                if (ds.getOrigin() != origin) continue;
                result.add(ds);
            }
        }
        return result;
    }

    private void updateProjectNature() {
        try {
            IProjectDescription description = this.project.getDescription();
            if (description != null) {
                Object[] natureIds = description.getNatureIds();
                if (this.dataSources.isEmpty()) {
                    if (ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                        description.setNatureIds((String[])ArrayUtils.remove(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                        this.project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else if (!ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        this.project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    private void saveFolder(XMLBuilder xml, DataSourceFolder folder) throws IOException {
        xml.startElement("folder");
        if (folder.getParent() != null) {
            xml.addAttribute("parent", folder.getParent().getFolderPath());
        }
        xml.addAttribute("name", folder.getName());
        if (!CommonUtils.isEmpty((String)folder.getDescription())) {
            xml.addAttribute("description", folder.getDescription());
        }
        xml.endElement();
    }

    private void saveDataSource(XMLBuilder xml, DataSourceDescriptor dataSource) throws IOException {
        String lockPasswordHash;
        xml.startElement("data-source");
        xml.addAttribute("id", dataSource.getId());
        xml.addAttribute("provider", dataSource.getDriver().getProviderDescriptor().getId());
        xml.addAttribute("driver", dataSource.getDriver().getId());
        xml.addAttribute("name", dataSource.getName());
        xml.addAttribute("save-password", dataSource.isSavePassword());
        if (dataSource.isShowSystemObjects()) {
            xml.addAttribute("show-system-objects", dataSource.isShowSystemObjects());
        }
        if (dataSource.isShowUtilityObjects()) {
            xml.addAttribute("show-util-objects", dataSource.isShowUtilityObjects());
        }
        xml.addAttribute("read-only", dataSource.isConnectionReadOnly());
        if (dataSource.getFolder() != null) {
            xml.addAttribute("folder", dataSource.getFolder().getFolderPath());
        }
        if (!CommonUtils.isEmpty((String)(lockPasswordHash = dataSource.getLockPasswordHash()))) {
            xml.addAttribute("lockPassword", lockPasswordHash);
        }
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        xml.startElement("connection");
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
            xml.addAttribute("host", connectionInfo.getHostName());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            xml.addAttribute("port", connectionInfo.getHostPort());
        }
        xml.addAttribute("server", CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        xml.addAttribute("database", CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        xml.addAttribute("url", CommonUtils.notEmpty((String)connectionInfo.getUrl()));
        this.saveSecuredCredentials(xml, dataSource, null, connectionInfo.getUserName(), dataSource.isSavePassword() ? connectionInfo.getUserPassword() : null);
        if (!CommonUtils.isEmpty((String)connectionInfo.getClientHomeId())) {
            xml.addAttribute("home", connectionInfo.getClientHomeId());
        }
        if (connectionInfo.getConnectionType() != null) {
            xml.addAttribute("type", connectionInfo.getConnectionType().getId());
        }
        if (connectionInfo.getConnectionColor() != null) {
            xml.addAttribute("color", connectionInfo.getConnectionColor());
        }
        if (connectionInfo.getKeepAliveInterval() > 0) {
            xml.addAttribute("keepAlive", connectionInfo.getKeepAliveInterval());
        }
        for (Map.Entry entry : connectionInfo.getProperties().entrySet()) {
            xml.startElement("property");
            xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
            xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
            xml.endElement();
        }
        for (Map.Entry entry : connectionInfo.getProviderProperties().entrySet()) {
            xml.startElement("provider-property");
            xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
            xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
            xml.endElement();
        }
        Object object = connectionInfo.getDeclaredEvents();
        int n = ((DBPConnectionEventType[])object).length;
        int n2 = 0;
        while (n2 < n) {
            DBPConnectionEventType eventType = object[n2];
            DBRShellCommand command = connectionInfo.getEvent(eventType);
            xml.startElement("event");
            xml.addAttribute("type", eventType.name());
            xml.addAttribute("enabled", command.isEnabled());
            xml.addAttribute("show-panel", command.isShowProcessPanel());
            xml.addAttribute("wait-process", command.isWaitProcessFinish());
            if (command.isWaitProcessFinish()) {
                xml.addAttribute("wait-process-timeout", command.getWaitProcessTimeoutMs());
            }
            xml.addAttribute("terminate-at-disconnect", command.isTerminateAtDisconnect());
            xml.addAttribute("pauseAfterExecute", command.getPauseAfterExecute());
            if (!CommonUtils.isEmpty((String)command.getWorkingDirectory())) {
                xml.addAttribute("workingDirectory", command.getWorkingDirectory());
            }
            xml.addText((CharSequence)command.getCommand());
            xml.endElement();
            ++n2;
        }
        for (DBWHandlerConfiguration configuration : connectionInfo.getDeclaredHandlers()) {
            xml.startElement("network-handler");
            xml.addAttribute("type", configuration.getType().name());
            xml.addAttribute("id", CommonUtils.notEmpty((String)configuration.getId()));
            xml.addAttribute("enabled", configuration.isEnabled());
            xml.addAttribute("save-password", configuration.isSavePassword());
            if (!CommonUtils.isEmpty((String)configuration.getUserName())) {
                this.saveSecuredCredentials(xml, dataSource, "network/" + configuration.getId(), configuration.getUserName(), configuration.isSavePassword() ? configuration.getPassword() : null);
            }
            for (Map.Entry entry : configuration.getProperties().entrySet()) {
                if (CommonUtils.isEmpty((String)((String)entry.getValue()))) continue;
                xml.startElement("property");
                xml.addAttribute("name", (String)entry.getKey());
                xml.addAttribute("value", CommonUtils.notEmpty((String)((String)entry.getValue())));
                xml.endElement();
            }
            xml.endElement();
        }
        DBPConnectionBootstrap bootstrap = connectionInfo.getBootstrap();
        if (bootstrap.hasData()) {
            xml.startElement("bootstrap");
            if (bootstrap.getDefaultAutoCommit() != null) {
                xml.addAttribute("autocommit", bootstrap.getDefaultAutoCommit().booleanValue());
            }
            if (bootstrap.getDefaultTransactionIsolation() != null) {
                xml.addAttribute("txnIsolation", bootstrap.getDefaultTransactionIsolation().intValue());
            }
            if (!CommonUtils.isEmpty((String)bootstrap.getDefaultObjectName())) {
                xml.addAttribute("defaultObject", bootstrap.getDefaultObjectName());
            }
            if (bootstrap.isIgnoreErrors()) {
                xml.addAttribute("ignoreErrors", true);
            }
            for (String query : bootstrap.getInitQueries()) {
                xml.startElement("query");
                xml.addText((CharSequence)query);
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
        Collection<FilterMapping> filterMappings = dataSource.getObjectFilters();
        if (!CommonUtils.isEmpty(filterMappings)) {
            xml.startElement("filters");
            for (FilterMapping filter : filterMappings) {
                if (filter.defaultFilter != null && !filter.defaultFilter.isEmpty()) {
                    this.saveObjectFiler(xml, filter.typeName, null, filter.defaultFilter);
                }
                for (Map.Entry entry : filter.customFilters.entrySet()) {
                    if (((DBSObjectFilter)entry.getValue()).isEmpty()) continue;
                    this.saveObjectFiler(xml, filter.typeName, (String)entry.getKey(), (DBSObjectFilter)entry.getValue());
                }
            }
            xml.endElement();
        }
        if (dataSource.getVirtualModel().hasValuableData()) {
            xml.startElement("virtual-meta-data");
            dataSource.getVirtualModel().serialize(xml);
            xml.endElement();
        }
        DataSourcePreferenceStore prefStore = dataSource.getPreferenceStore();
        object = prefStore.preferenceNames();
        int n3 = ((String[])object).length;
        int n32 = 0;
        while (n32 < n3) {
            DBPConnectionEventType propName = object[n32];
            String propValue = prefStore.getString((String)propName);
            String defValue = prefStore.getDefaultString((String)propName);
            if (propValue != null && !CommonUtils.equalObjects((Object)propValue, (Object)defValue)) {
                xml.startElement("custom-property");
                xml.addAttribute("name", (String)propName);
                xml.addAttribute("value", propValue);
                xml.endElement();
            }
            ++n32;
        }
        if (!CommonUtils.isEmpty((String)dataSource.getDescription())) {
            xml.startElement("description");
            xml.addText((CharSequence)dataSource.getDescription());
            xml.endElement();
        }
        xml.endElement();
    }

    private void saveSecuredCredentials(XMLBuilder xml, DataSourceDescriptor dataSource, String subNode, String userName, String password) throws IOException {
        boolean saved = false;
        DBASecureStorage secureStorage = this.getPlatform().getSecureStorage();
        try {
            ISecurePreferences prefNode = dataSource.getSecurePreferences();
            if (!secureStorage.useSecurePreferences()) {
                prefNode.removeNode();
            } else {
                if (subNode != null) {
                    String[] stringArray = subNode.split("/");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nodeName = stringArray[n2];
                        prefNode = prefNode.node(nodeName);
                        ++n2;
                    }
                }
                prefNode.put("name", dataSource.getName(), false);
                if (!CommonUtils.isEmpty((String)userName)) {
                    prefNode.put("user", userName, true);
                    saved = true;
                } else {
                    prefNode.remove("user");
                }
                if (!CommonUtils.isEmpty((String)password)) {
                    prefNode.put("password", password, true);
                    saved = true;
                } else {
                    prefNode.remove("password");
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Can't save password in secure storage", e);
        }
        if (!saved) {
            try {
                if (!CommonUtils.isEmpty((String)userName)) {
                    xml.addAttribute("user", CommonUtils.notEmpty((String)userName));
                }
                if (!CommonUtils.isEmpty((String)password)) {
                    xml.addAttribute("password", ENCRYPTOR.encrypt(password));
                }
            }
            catch (EncryptionException e) {
                log.error((Object)"Error encrypting password", (Throwable)e);
            }
        }
    }

    private void clearSecuredPasswords(DataSourceDescriptor dataSource) {
        try {
            dataSource.getSecurePreferences().removeNode();
        }
        catch (Throwable throwable) {
            log.debug((Object)("Error clearing '" + dataSource.getId() + "' secure storage"));
        }
    }

    @Nullable
    private static String decryptPassword(String encPassword) {
        if (!CommonUtils.isEmpty((String)encPassword)) {
            try {
                encPassword = ENCRYPTOR.decrypt(encPassword);
            }
            catch (Throwable throwable) {
                encPassword = null;
            }
        }
        return encPassword;
    }

    private void saveObjectFiler(XMLBuilder xml, String typeName, String objectID, DBSObjectFilter filter) throws IOException {
        xml.startElement("filter");
        if (typeName != null) {
            xml.addAttribute("type", typeName);
        }
        if (objectID != null) {
            xml.addAttribute("id", objectID);
        }
        if (!CommonUtils.isEmpty((String)filter.getName())) {
            xml.addAttribute("name", filter.getName());
        }
        if (!CommonUtils.isEmpty((String)filter.getDescription())) {
            xml.addAttribute("description", filter.getDescription());
        }
        if (!filter.isEnabled()) {
            xml.addAttribute("enabled", false);
        }
        for (String include : CommonUtils.safeCollection((Collection)filter.getInclude())) {
            xml.startElement("include");
            xml.addAttribute("name", include);
            xml.endElement();
        }
        for (String exclude : CommonUtils.safeCollection((Collection)filter.getExclude())) {
            xml.startElement("exclude");
            xml.addAttribute("name", exclude);
            xml.endElement();
        }
        xml.endElement();
    }

    public IProject getProject() {
        return this.project;
    }

    private class DataSourcesParser
    implements SAXListener {
        DataSourceDescriptor curDataSource;
        DataSourceOrigin origin;
        boolean refresh;
        boolean isDescription = false;
        DBRShellCommand curCommand = null;
        private DBWHandlerConfiguration curNetworkHandler;
        private DBSObjectFilter curFilter;
        private StringBuilder curQuery;
        private ParseResults parseResults;
        private boolean passwordReadCanceled = false;

        private DataSourcesParser(DataSourceOrigin origin, boolean refresh, ParseResults parseResults) {
            this.origin = origin;
            this.refresh = refresh;
            this.parseResults = parseResults;
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            this.isDescription = false;
            this.curCommand = null;
            block18 : switch (localName) {
                case "folder": {
                    DataSourceFolder folder;
                    String name = atts.getValue("name");
                    String description = atts.getValue("description");
                    String parentFolder = atts.getValue("parent");
                    DataSourceFolder parent = parentFolder == null ? null : DataSourceRegistry.this.findFolderByPath(parentFolder, true);
                    DataSourceFolder dataSourceFolder = folder = parent == null ? DataSourceRegistry.this.findFolderByPath(name, true) : parent.getChild(name);
                    if (folder == null) {
                        folder = new DataSourceFolder(DataSourceRegistry.this, parent, name, description);
                        DataSourceRegistry.this.dataSourceFolders.add(folder);
                        break;
                    }
                    folder.setDescription(description);
                    break;
                }
                case "data-source": {
                    String legacySchemaFilter;
                    boolean newDataSource;
                    String name = atts.getValue("name");
                    String id = atts.getValue("id");
                    if (id == null) {
                        id = name;
                    }
                    String providerId = atts.getValue("provider");
                    DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                    if (provider == null) {
                        log.warn((Object)("Can't find datasource provider " + providerId + " for datasource '" + name + "'"));
                        this.curDataSource = null;
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    String driverId = atts.getValue("driver");
                    DriverDescriptor driver = provider.getDriver(driverId);
                    if (driver == null) {
                        log.warn((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + name + "'. Create new driver"));
                        driver = provider.createDriver(driverId);
                        provider.addDriver(driver);
                    }
                    this.curDataSource = DataSourceRegistry.this.getDataSource(id);
                    boolean bl = newDataSource = this.curDataSource == null;
                    if (newDataSource) {
                        this.curDataSource = new DataSourceDescriptor(DataSourceRegistry.this, this.origin, id, driver, new DBPConnectionConfiguration());
                    } else {
                        this.curDataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                        this.curDataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                        this.curDataSource.clearFilters();
                    }
                    this.curDataSource.setName(name);
                    this.curDataSource.setSavePassword(CommonUtils.getBoolean((String)atts.getValue("save-password")));
                    this.curDataSource.setShowSystemObjects(CommonUtils.getBoolean((String)atts.getValue("show-system-objects")));
                    this.curDataSource.setShowUtilityObjects(CommonUtils.getBoolean((String)atts.getValue("show-util-objects")));
                    this.curDataSource.setConnectionReadOnly(CommonUtils.getBoolean((String)atts.getValue("read-only")));
                    String folderPath = atts.getValue("folder");
                    if (folderPath != null) {
                        this.curDataSource.setFolder(DataSourceRegistry.this.findFolderByPath(folderPath, true));
                    }
                    this.curDataSource.setLockPasswordHash(atts.getValue("lockPassword"));
                    String legacyCatalogFilter = atts.getValue("filter-catalog");
                    if (!CommonUtils.isEmpty((String)legacyCatalogFilter)) {
                        this.curDataSource.updateObjectFilter(DBSCatalog.class.getName(), null, new DBSObjectFilter(legacyCatalogFilter, null));
                    }
                    if (!CommonUtils.isEmpty((String)(legacySchemaFilter = atts.getValue("filter-schema")))) {
                        this.curDataSource.updateObjectFilter(DBSSchema.class.getName(), null, new DBSObjectFilter(legacySchemaFilter, null));
                    }
                    if (newDataSource) {
                        DataSourceRegistry.this.dataSources.add(this.curDataSource);
                        this.parseResults.addedDataSources.add(this.curDataSource);
                        break;
                    }
                    this.parseResults.updatedDataSources.add(this.curDataSource);
                    break;
                }
                case "connection": {
                    String keepAlive;
                    if (this.curDataSource == null) break;
                    DriverDescriptor driver = this.curDataSource.getDriver();
                    if (CommonUtils.isEmpty((String)driver.getName())) {
                        driver.setName(atts.getValue("url"));
                        driver.setDriverClassName("java.sql.Driver");
                    }
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    config.setHostName(atts.getValue("host"));
                    config.setHostPort(atts.getValue("port"));
                    config.setServerName(atts.getValue("server"));
                    config.setDatabaseName(atts.getValue("database"));
                    config.setUrl(atts.getValue("url"));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(atts, this.curDataSource, null);
                        config.setUserName(creds[0]);
                        if (this.curDataSource.isSavePassword()) {
                            config.setUserPassword(creds[1]);
                        }
                    }
                    config.setClientHomeId(atts.getValue("home"));
                    config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(CommonUtils.toString((Object)atts.getValue("type")), DBPConnectionType.DEFAULT_TYPE));
                    String colorValue = atts.getValue("color");
                    if (!CommonUtils.isEmpty((String)colorValue)) {
                        config.setConnectionColor(colorValue);
                    }
                    if (CommonUtils.isEmpty((String)(keepAlive = atts.getValue("keepAlive")))) break;
                    try {
                        config.setKeepAliveInterval(Integer.parseInt(keepAlive));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)"Bad keep-alive interval value", (Throwable)e);
                    }
                    break;
                }
                case "bootstrap": {
                    if (this.curDataSource == null) break;
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    if (atts.getValue("autocommit") != null) {
                        config.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)atts.getValue("autocommit"))));
                    }
                    if (atts.getValue("txnIsolation") != null) {
                        config.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)atts.getValue("txnIsolation"))));
                    }
                    if (!CommonUtils.isEmpty((String)atts.getValue("defaultObject"))) {
                        config.getBootstrap().setDefaultObjectName(atts.getValue("defaultObject"));
                    }
                    if (atts.getValue("ignoreErrors") == null) break;
                    config.getBootstrap().setIgnoreErrors(CommonUtils.toBoolean((Object)atts.getValue("ignoreErrors")));
                    break;
                }
                case "query": {
                    this.curQuery = new StringBuilder();
                    break;
                }
                case "property": {
                    if (this.curNetworkHandler != null) {
                        this.curNetworkHandler.getProperties().put(atts.getValue("name"), atts.getValue("value"));
                        break;
                    }
                    if (this.curDataSource == null) break;
                    String propName = atts.getValue("name");
                    String propValue = atts.getValue("value");
                    if (propName == null) break;
                    if (propName.startsWith("@dbeaver-")) {
                        this.curDataSource.getConnectionConfiguration().setProviderProperty(propName, propValue);
                        break;
                    }
                    this.curDataSource.getConnectionConfiguration().setProperty(propName, propValue);
                    break;
                }
                case "provider-property": {
                    if (this.curDataSource == null) break;
                    this.curDataSource.getConnectionConfiguration().setProviderProperty(atts.getValue("name"), atts.getValue("value"));
                    break;
                }
                case "event": {
                    if (this.curDataSource == null) break;
                    DBPConnectionEventType eventType = DBPConnectionEventType.valueOf((String)atts.getValue("type"));
                    this.curCommand = new DBRShellCommand("");
                    this.curCommand.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled")));
                    this.curCommand.setShowProcessPanel(CommonUtils.getBoolean((String)atts.getValue("show-panel")));
                    this.curCommand.setWaitProcessFinish(CommonUtils.getBoolean((String)atts.getValue("wait-process")));
                    if (this.curCommand.isWaitProcessFinish()) {
                        String timeoutString = atts.getValue("wait-process-timeout");
                        int timeoutMs = CommonUtils.toInt((Object)timeoutString, (int)-1);
                        this.curCommand.setWaitProcessTimeoutMs(timeoutMs);
                    }
                    this.curCommand.setTerminateAtDisconnect(CommonUtils.getBoolean((String)atts.getValue("terminate-at-disconnect")));
                    this.curCommand.setPauseAfterExecute(CommonUtils.toInt((Object)atts.getValue("pauseAfterExecute")));
                    this.curCommand.setWorkingDirectory(atts.getValue("workingDirectory"));
                    this.curDataSource.getConnectionConfiguration().setEvent(eventType, this.curCommand);
                    break;
                }
                case "custom-property": {
                    if (this.curDataSource == null) break;
                    String propName = atts.getValue("name");
                    String propValue = atts.getValue("value");
                    switch (propName) {
                        case "default.autocommit": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)propValue)));
                            break block18;
                        }
                        case "default.isolation": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)propValue)));
                            break block18;
                        }
                        case "default.activeObject": {
                            if (CommonUtils.isEmpty((String)propValue)) break block18;
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultObjectName(propValue);
                            break block18;
                        }
                    }
                    this.curDataSource.getPreferenceStore().getProperties().put(propName, propValue);
                    break;
                }
                case "network-handler": {
                    if (this.curDataSource == null) break;
                    String handlerId = atts.getValue("id");
                    NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
                    if (handlerDescriptor == null) {
                        log.warn((Object)("Can't find network handler '" + handlerId + "'"));
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    this.curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDriver)this.curDataSource.getDriver());
                    this.curNetworkHandler.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled")));
                    this.curNetworkHandler.setSavePassword(CommonUtils.getBoolean((String)atts.getValue("save-password")));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(atts, this.curDataSource, "network/" + handlerId);
                        this.curNetworkHandler.setUserName(creds[0]);
                        if (this.curNetworkHandler.isSavePassword()) {
                            this.curNetworkHandler.setPassword(creds[1]);
                        }
                    }
                    this.curDataSource.getConnectionConfiguration().addHandler(this.curNetworkHandler);
                    break;
                }
                case "filter": {
                    if (this.curDataSource != null) {
                        String typeName = atts.getValue("type");
                        String objectID = atts.getValue("id");
                        if (typeName == null) break;
                        this.curFilter = new DBSObjectFilter();
                        this.curFilter.setName(atts.getValue("name"));
                        this.curFilter.setDescription(atts.getValue("description"));
                        this.curFilter.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled"), (boolean)true));
                        this.curDataSource.updateObjectFilter(typeName, objectID, this.curFilter);
                        break;
                    }
                    this.curFilter = new DBSObjectFilter();
                    this.curFilter.setName(atts.getValue("name"));
                    this.curFilter.setDescription(atts.getValue("description"));
                    this.curFilter.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled"), (boolean)true));
                    DataSourceRegistry.this.savedFilters.add(this.curFilter);
                    break;
                }
                case "include": {
                    if (this.curFilter == null) break;
                    this.curFilter.addInclude(CommonUtils.notEmpty((String)atts.getValue("name")));
                    break;
                }
                case "exclude": {
                    if (this.curFilter == null) break;
                    this.curFilter.addExclude(CommonUtils.notEmpty((String)atts.getValue("name")));
                    break;
                }
                case "description": {
                    this.isDescription = true;
                    break;
                }
                case "virtual-meta-data": {
                    if (this.curDataSource == null) break;
                    reader.setListener(this.curDataSource.getVirtualModel().getModelParser());
                }
            }
        }

        public void saxText(SAXReader reader, String data) throws XMLException {
            if (this.isDescription && this.curDataSource != null) {
                this.curDataSource.setDescription(data);
            } else if (this.curCommand != null) {
                this.curCommand.setCommand(data);
                this.curCommand = null;
            } else if (this.curQuery != null) {
                this.curQuery.append(data);
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            switch (localName) {
                case "data-source": {
                    this.curDataSource = null;
                    break;
                }
                case "network-handler": {
                    this.curNetworkHandler = null;
                    break;
                }
                case "filter": {
                    this.curFilter = null;
                    break;
                }
                case "query": {
                    if (this.curDataSource == null || this.curQuery == null || this.curQuery.length() <= 0) break;
                    this.curDataSource.getConnectionConfiguration().getBootstrap().getInitQueries().add(this.curQuery.toString());
                    this.curQuery = null;
                }
            }
            this.isDescription = false;
        }

        private String[] readSecuredCredentials(Attributes xmlAttrs, DataSourceDescriptor dataSource, String subNode) {
            String[] creds = new String[2];
            DBASecureStorage secureStorage = DataSourceRegistry.this.getPlatform().getSecureStorage();
            try {
                if (secureStorage.useSecurePreferences()) {
                    ISecurePreferences prefNode = dataSource.getSecurePreferences();
                    if (subNode != null) {
                        String[] stringArray = subNode.split("/");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String nodeName = stringArray[n2];
                            prefNode = prefNode.node(nodeName);
                            ++n2;
                        }
                    }
                    creds[0] = prefNode.get("user", null);
                    creds[1] = prefNode.get("password", null);
                }
            }
            catch (Throwable e) {
                log.error((Object)"Can't read password from secure storage", e);
                this.passwordReadCanceled = true;
            }
            if (CommonUtils.isEmpty((String)creds[0])) {
                creds[0] = xmlAttrs.getValue("user");
            }
            if (CommonUtils.isEmpty((String)creds[1])) {
                String encPassword = xmlAttrs.getValue("password");
                creds[1] = CommonUtils.isEmpty((String)encPassword) ? null : DataSourceRegistry.decryptPassword(encPassword);
            }
            return creds;
        }
    }

    private class DisconnectTask
    implements DBRRunnableWithProgress {
        boolean disconnected;

        private DisconnectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            List dsSnapshot;
            List list = DataSourceRegistry.this.dataSources;
            synchronized (list) {
                dsSnapshot = CommonUtils.copyList((Collection)DataSourceRegistry.this.dataSources);
            }
            monitor.beginTask("Disconnect all databases", dsSnapshot.size());
            try {
                for (DataSourceDescriptor dataSource : dsSnapshot) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (dataSource.isConnected()) {
                        try {
                            monitor.subTask("Disconnect from [" + dataSource.getName() + "]");
                            this.disconnected = dataSource.disconnect(monitor);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Can't shutdown data source '" + dataSource.getName() + "'"), (Throwable)ex);
                        }
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static class ParseResults {
        Set<DataSourceDescriptor> updatedDataSources = new HashSet<DataSourceDescriptor>();
        Set<DataSourceDescriptor> addedDataSources = new HashSet<DataSourceDescriptor>();

        private ParseResults() {
        }
    }
}

