/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;

final class AutoComplete {
    private AutoComplete() {
    }

    static class SelectionAction
    implements Action {
        private Action delegate;

        public SelectionAction(Action delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            JTextComponent textComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
            AutoCompleteDocument doc = (AutoCompleteDocument)textComponent.getDocument();
            doc.strictMatching = true;
            try {
                this.delegate.actionPerformed(e);
            }
            finally {
                doc.strictMatching = false;
            }
        }

        public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }
    }

    static class PropertyChangeListener
    implements java.beans.PropertyChangeListener {
        private JComboBox comboBox;

        public PropertyChangeListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof AutoCompleteComboBoxEditor) {
                return;
            }
            AutoCompleteComboBoxEditor acEditor = (AutoCompleteComboBoxEditor)evt.getOldValue();
            boolean strictMatching = false;
            if (acEditor.getEditorComponent() != null) {
                JTextComponent textComponent = (JTextComponent)acEditor.getEditorComponent();
                strictMatching = ((AutoCompleteDocument)textComponent.getDocument()).strictMatching;
                AutoCompleteDecorator.undecorate(textComponent);
                for (KeyListener l : textComponent.getKeyListeners()) {
                    if (!(l instanceof KeyAdapter)) continue;
                    textComponent.removeKeyListener(l);
                    break;
                }
            }
            JTextComponent editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            ComboBoxAdaptor adaptor = new ComboBoxAdaptor(this.comboBox);
            AutoCompleteDocument document = AutoCompleteDecorator.createAutoCompleteDocument(adaptor, strictMatching, acEditor.stringConverter, editorComponent.getDocument());
            AutoCompleteDecorator.decorate(editorComponent, document, adaptor);
            editorComponent.addKeyListener(new KeyAdapter(this.comboBox));
            this.comboBox.setEditor(new AutoCompleteComboBoxEditor(this.comboBox.getEditor(), document.stringConverter));
        }
    }

    static class KeyAdapter
    extends java.awt.event.KeyAdapter {
        private JComboBox comboBox;

        public KeyAdapter(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isActionKey()) {
                return;
            }
            if (this.comboBox.isDisplayable() && !this.comboBox.isPopupVisible()) {
                int keyCode = keyEvent.getKeyCode();
                if (keyCode == 16 || keyCode == 17 || keyCode == 18) {
                    return;
                }
                if (keyCode == 10 || keyCode == 27) {
                    return;
                }
                this.comboBox.setPopupVisible(true);
            }
        }
    }

    static class FocusAdapter
    extends java.awt.event.FocusAdapter {
        private AbstractAutoCompleteAdaptor adaptor;

        public FocusAdapter(AbstractAutoCompleteAdaptor adaptor) {
            this.adaptor = adaptor;
        }

        public void focusGained(FocusEvent e) {
            this.adaptor.markEntireText();
        }
    }

    static class InputMap
    extends javax.swing.InputMap {
        private static final long serialVersionUID = 1L;

        InputMap() {
        }
    }
}

