/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.time.Duration;

public class DurationCodec
implements ObjectCodec<Duration> {
    @Override
    public void serialize(SerializationContext context, Duration obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt64NoTag(obj.getSeconds());
        codedOut.writeInt32NoTag(obj.getNano());
    }

    @Override
    public Duration deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        return Duration.ofSeconds(codedIn.readInt64(), codedIn.readInt32());
    }

    @Override
    public Class<Duration> getEncodedClass() {
        return Duration.class;
    }
}

