Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var StyleguideSection = (function () {
  function StyleguideSection(props, children) {
    _classCallCheck(this, StyleguideSection);

    this.collapsed = props.collapsed;
    this.title = props.title;
    this.name = props.name;
    this.children = children;
    _etch2['default'].initialize(this);
    if (props.onDidInitialize) {
      props.onDidInitialize(this);
    }
  }

  _createClass(StyleguideSection, [{
    key: 'render',
    value: function render() {
      var _this = this;

      if (this.loaded) {
        var className = 'bordered';
        if (this.collapsed) {
          className += ' collapsed';
        }
        return _etch2['default'].dom(
          'section',
          { className: className, dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          ),
          this.children
        );
      } else {
        return _etch2['default'].dom(
          'section',
          { className: 'bordered collapsed', dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          )
        );
      }
    }
  }, {
    key: 'update',
    value: function update(props, children) {
      if (props.title) {
        this.title = props.title;
      }

      if (props.name) {
        this.name = props.name;
      }

      if (children) {
        this.children = children;
      }

      if (props.didExpandOrCollapseSection) {
        this.didExpandOrCollapseSection = props.onDidExpandOrCollapseSection;
      }

      return _etch2['default'].update(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      return this.collapsed ? this.expand() : this.collapse();
    }
  }, {
    key: 'expand',
    value: function expand() {
      this.collapsed = false;
      this.loaded = true;
      return _etch2['default'].update(this);
    }
  }, {
    key: 'collapse',
    value: function collapse() {
      this.collapsed = true;
      return _etch2['default'].update(this);
    }
  }]);

  return StyleguideSection;
})();

exports['default'] = StyleguideSection;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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