Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (typeof repoUrl === 'string') {
        if (_url2['default'].parse(repoUrl).pathname === '/atom/atom') {
          _electron.shell.openExternal(repoUrl + '/tree/master/packages/' + _this.pack.name);
        } else {
          _electron.shell.openExternal(repoUrl);
        }
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (repoUrl) {
        _electron.shell.openExternal(repoUrl + '/issues/new');
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panels-item' },
          _etch2['default'].dom(
            'section',
            { className: 'section' },
            _etch2['default'].dom(
              'form',
              { className: 'section-container package-detail-view' },
              _etch2['default'].dom(
                'div',
                { className: 'container package-container' },
                packageCardView
              ),
              _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
              _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
              _etch2['default'].dom(
                'div',
                { ref: 'buttons', className: 'btn-wrap-group hidden' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                  'View on Atom.io'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                  'Report Issue'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                  'CHANGELOG'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                  'LICENSE'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                  'View Code'
                )
              ),
              _etch2['default'].dom('div', { ref: 'errors' })
            )
          ),
          _etch2['default'].dom('div', { ref: 'sections' })
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeSrc = undefined;

      if (this.pack.path) {
        // If package is installed, use installed path
        readmeSrc = this.pack.path;
      } else {
        // If package isn't installed, use url path
        var repoUrl = this.packageManager.getRepositoryUrl(this.pack);

        // Check if URL is undefined (i.e. package is unpublished)
        if (repoUrl) {
          readmeSrc = repoUrl + '/blob/master/';
        }
      }

      var readmeView = new _packageReadmeView2['default'](readme, readmeSrc);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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