Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var InstalledPackagesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(InstalledPackagesPanel, _CollapsibleSectionPanel);

  _createClass(InstalledPackagesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function InstalledPackagesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstalledPackagesPanel);

    _get(Object.getPrototypeOf(InstalledPackagesPanel.prototype), 'constructor', this).call(this);
    _etch2['default'].initialize(this);
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name'),
      deprecated: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this)),
      deprecated: new _listView2['default'](this.items.deprecated, this.refs.deprecatedPackages, this.createPackageCard.bind(this))
    };

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
    this.subscriptions.add(this.packageManager.on('package-install-failed theme-install-failed package-uninstall-failed theme-uninstall-failed package-update-failed theme-update-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));

    var loadPackagesTimeout = undefined;
    this.subscriptions.add(this.packageManager.on('package-updated package-installed package-uninstalled package-installed-alternative', function () {
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(_this.loadPackages.bind(_this), InstalledPackagesPanel.loadPackagesDelay());
    }));

    this.subscriptions.add(this.handleEvents());
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadPackages();
  }

  _createClass(InstalledPackagesPanel, [{
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-package' },
              'Installed Packages',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter packages by name' })
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'section',
              { ref: 'deprecatedSection', className: 'sub-section deprecated-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'deprecatedPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Deprecated Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'deprecatedCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'p',
                null,
                'Atom does not load deprecated packages. These packages may have updates available.'
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'deprecatedPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'deprecatedLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Community Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'corePackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Core Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'devPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Development Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Git Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return !theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return !theme;
      });
      packages.deprecated = packages.user.filter(function (_ref4) {
        var name = _ref4.name;
        var version = _ref4.version;
        return atom.packages.isDeprecatedPackage(name, version);
      });
      packages.core = packages.core.filter(function (_ref5) {
        var theme = _ref5.theme;
        return !theme;
      });
      packages.git = (packages.git || []).filter(function (_ref6) {
        var theme = _ref6.theme;
        return !theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }

      return packages;
    }
  }, {
    key: 'sortPackages',
    value: function sortPackages(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      packages.deprecated.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      var packagesWithUpdates = {};
      this.packageManager.getOutdated().then(function (packages) {
        for (var _ref72 of packages) {
          var _name = _ref72.name;
          var latestVersion = _ref72.latestVersion;

          packagesWithUpdates[_name] = latestVersion;
        }
        _this2.displayPackageUpdates(packagesWithUpdates);
      });

      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortPackages(_this2.filterPackages(packages));
        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        if (_this2.packages.deprecated.length) {
          _this2.refs.deprecatedSection.style.display = '';
        } else {
          _this2.refs.deprecatedSection.style.display = 'none';
        }
        _this2.refs.deprecatedLoadingArea.remove();
        _this2.items.deprecated.setItems(_this2.packages.deprecated);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
        _this2.displayPackageUpdates(packagesWithUpdates);

        _this2.matchPackages();
      })['catch'](function (error) {
        console.error(error.message, error.stack);
      });
    }
  }, {
    key: 'displayPackageUpdates',
    value: function displayPackageUpdates(packagesWithUpdates) {
      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var packageCard of this.itemViews[packageType].getViews()) {
          var newVersion = packagesWithUpdates[packageCard.pack.name];
          if (newVersion) {
            packageCard.displayAvailableUpdate(newVersion);
          }
        }
      }
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Packages' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, this.packages.deprecated.length);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, this.packages.git.length);

      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = totalPackages.toString();
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var deprecated = this.notHiddenCardsLength(this.refs.deprecatedPackages);
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, deprecated, this.packages.deprecated.length);

      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, community, this.packages.user.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, core, this.packages.core.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownPackages = dev + core + community + git;
      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownPackages + '/' + totalPackages;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.deprecatedPackagesHeader, this.refs.communityPackagesHeader, this.refs.corePackagesHeader, this.refs.devPackagesHeader, this.refs.gitPackagesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstalledPackagesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = InstalledPackagesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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