/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 */
import { GraphQLError } from '../error/GraphQLError';

/**
 * Extracts the root type of the operation from the schema.
 */
export function getOperationRootType(schema, operation) {
  switch (operation.operation) {
    case 'query':
      var queryType = schema.getQueryType();

      if (!queryType) {
        throw new GraphQLError('Schema does not define the required query root type.', operation);
      }

      return queryType;

    case 'mutation':
      var mutationType = schema.getMutationType();

      if (!mutationType) {
        throw new GraphQLError('Schema is not configured for mutations.', operation);
      }

      return mutationType;

    case 'subscription':
      var subscriptionType = schema.getSubscriptionType();

      if (!subscriptionType) {
        throw new GraphQLError('Schema is not configured for subscriptions.', operation);
      }

      return subscriptionType;

    default:
      throw new GraphQLError('Can only have query, mutation and subscription operations.', operation);
  }
}